/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.action.user;

import java.util.Calendar;

import nuts.aems.model.bean.CommonBean;
import nuts.core.orm.dao.QueryParameter;

import squirrels.affiliate.action.AbstractModelDrivenAction;

/**
 * @param <T> data type
 * @param <E> example type
 */
@SuppressWarnings("serial")
public abstract class AbstractUserModelDrivenAction<T extends CommonBean, E extends QueryParameter> 
	extends AbstractModelDrivenAction<T, E> {

	/**
	 * checkUpdated
	 * @param data data
	 * @param srcData srcData
	 * @return true if check successfully
	 * @throws Exception if an error occurs
	 */
	@Override
	protected boolean checkUpdated(T data, T srcData) throws Exception {
		// no check
		return true;
	}

	/**
	 * checkOnInsert
	 * @param data data
	 * @throws Exception if an error occurs
	 */
	@Override
	protected boolean checkOnInsert(T data) throws Exception {
		if (data.getInvalid() == null) {
			data.setInvalid(false);
		}
		data.setUusid(utils().getLoginUser().getId());
		data.setUtime(Calendar.getInstance().getTime());
		
		return super.checkOnInsert(data);
	}

	/**
	 * checkOnUpdate
	 * @param data data
	 * @param srcData srcData
	 * @throws Exception if an error occurs
	 */
	@Override
	protected boolean checkOnUpdate(T data, T srcData) throws Exception {
		if (data.getInvalid() == null) {
			data.setInvalid(false);
		}
		data.setUusid(utils().getLoginUser().getId());
		data.setUtime(Calendar.getInstance().getTime());
		
		return super.checkOnUpdate(data, srcData);
	}
}