package squirrels.affiliate.model;

import java.util.HashMap;
import java.util.Map;

import squirrels.affiliate.model.bean.Category;

/**
 * Genre
 */
@SuppressWarnings("serial")
public abstract class CategoryModel extends Category {
	private static CategoryModel instance;
	
	private static Map<Object, Category> cache = new HashMap<Object, Category>();

	/**
	 * @return the instance
	 */
	public static CategoryModel getInstance() {
		return instance;
	}

	/**
	 * @param instance the instance to set
	 */
	public static void setInstance(CategoryModel instance) {
		CategoryModel.instance = instance;
	}

	/**
	 * Constructor
	 */
	public CategoryModel() {
		super();
	}

	protected static Map<Object, Category> getCache() {
		return cache;
	}
	
	/**
	 */
	public static void initCache() {
		cache = new HashMap<Object, Category>();
	}

	/**
	 * @param c category
	 * @return category
	 */
	public Category getTopCategory(Category c) {
		if (c != null) {
			while (c.getParent() != null) {
				c = c.getParent();
			}
		}
		return c;
	}

	/**
	 * @return category
	 */
	public abstract Category getRootCategory();

	/**
	 * @param cid category Id
	 * @return category
	 */
	public abstract Category getCategory(String cid);
	
}

