package squirrels.affiliate.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

import nuts.core.collections.ExpireMap;
import nuts.core.lang.StringUtils;

import squirrels.affiliate.model.bean.Item;

/**
 * ItemModel
 */
@SuppressWarnings("serial")
public abstract class ItemModel extends Item {
	/**
	 * default expire time 12h
	 */
	public static final int DEFAULT_EXPIRE = 12 * 60 * 60;
	
	private static ItemModel instance;
	
	private static Map<String, Item> cache;
	
	static {
		initCache();
	}

	/**
	 * @return the instance
	 */
	public static ItemModel getInstance() {
		return instance;
	}

	/**
	 * @param instance the instance to set
	 */
	public static void setInstance(ItemModel instance) {
		ItemModel.instance = instance;
	}

	/**
	 * init cache
	 */
	public static void initCache() {
		initCache(DEFAULT_EXPIRE);
	}

	/**
	 * init cache
	 * @param expire expire time (s)
	 */
	public static void initCache(int expire) {
		ExpireMap<String, Item> em = new ExpireMap<String, Item>(new WeakHashMap<String, Item>(), expire * 1000);
		cache = Collections.synchronizedMap(em);
	}

	protected static Map<String, Item> getCache() {
		return cache;
	}
	
	public static class Result {
		private int count = 0;
		private List<Item> items = new ArrayList<Item>();
		/**
		 * @return the count
		 */
		public int getCount() {
			return count;
		}
		/**
		 * @param count the count to set
		 */
		public void setCount(int count) {
			this.count = count;
		}
		/**
		 * @return the items
		 */
		public List<Item> getItems() {
			return items;
		}
		/**
		 * @param items the items to set
		 */
		public void setItems(List<Item> items) {
			this.items = items;
		}
	}

	public abstract Item getItem(String code);
	
	public abstract Result search(String cateId, String keyword, String sort, boolean asc, int page, int limit);

	public abstract List<Item> ranking(String cateId);

	public String getImageUrl() {
		return StringUtils.isEmpty(mediumImageUrl) ? smallImageUrl : mediumImageUrl;
	}
}

