/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.util;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

import nuts.aems.util.BaseActionUtils;
import nuts.core.taskqueue.TaskQueueFactory;
import nuts.core.taskqueue.TaskQueueOptions;
import nuts.exts.struts2.actions.CommonAction;
import nuts.exts.struts2.util.StrutsContextUtils;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;

import squirrels.affiliate.Application;
import squirrels.affiliate.model.CategoryModel;
import squirrels.affiliate.model.bean.Category;


/**
 * ActionUtils.
 */
public class ActionUtils extends BaseActionUtils {

	private Category rootCategory;
	
	/**
	 * Constructor
	 */
	public ActionUtils(CommonAction action) {
		super(action);
	}

	/**
	 * @param cid category id
	 * @return category image dir
	 */
	public FileObject getCategoryImagesPath(String cid) throws IOException {
		return Application.getCategoryImagesDir().resolveFile(cid);
	}

	/**
	 * @param c category
	 * @return category image dir
	 */
	public FileObject getCategoryImagesPath(Category c) throws IOException {
		return getCategoryImagesPath(c.getId());
	}
	
	/**
	 * @param sid super id
	 * @param cid category id
	 * @return true if sid is super of cid
	 */
	public boolean isSuperCategory(String sid, String cid) {
		try {
			Category c = getCategory(cid);
			while (c != null) {
				if (c.getId().equals(sid)) {
					return true;
				}
				c = c.getParent();
			}
		}
		catch (Exception e) {
			
		}
		return false;
	}

	private String subdomain;
	public String getSubdomain() {
		if (subdomain == null) {
			String domain = StrutsContextUtils.getServletRequest().getServerName();
			subdomain = StringUtils.substringBefore(domain, ".").toLowerCase();
		}
		return subdomain;
	}

	public String getSiteTitle() {
		String sd = getSubdomain();
		String sn = getAction().getText("site-title-" + sd, (String)null);
		if (sn == null) {
			sn = getAction().getText("site-title", "");
		}
		return sn;
	}

	public String getSiteName() {
		String sd = getSubdomain();
		String sn = getAction().getText("site-name-" + sd, (String)null);
		if (sn == null) {
			sn = getAction().getText("site-name", "");
		}
		return sn;
	}

	public String getSiteDesc() {
		String sd = getSubdomain();
		String sn = getAction().getText("site-desc-" + sd, (String)null);
		if (sn == null) {
			sn = getAction().getText("site-desc", "");
		}
		return sn;
	}

	public String getSiteDescrip() {
		String sd = getSubdomain();
		String sn = getAction().getText("site-descrip-" + sd, (String)null);
		if (sn == null) {
			sn = getAction().getText("site-descrip", "");
		}
		return sn;
	}

	public String getSiteKeyword() {
		String sd = getSubdomain();
		String sn = getAction().getText("site-keyword-" + sd, (String)null);
		if (sn == null) {
			sn = getAction().getText("site-keyword", "");
		}
		return sn;
	}
	
	public String getCatePkg() {
		if ("ranking".equals(getSubdomain())) {
			return "rank";
		}
		return "genre";
	}

	/**
	 * @return category instance
	 */
	public Category getRootCategory() {
		if (rootCategory == null) {
			String subdomain = getSubdomain();
			ActionConsts cons = (ActionConsts)getAction().getConsts();
			String cid = cons.getDomainMap().get(subdomain);
			if (cid == null) {
				cid = cons.getDomainMap().get("*");
			}
			if (cid == null) {
				rootCategory = CategoryModel.getInstance().getRootCategory();
				if (rootCategory != null) {
					rootCategory.setName(getAction().getText("site-title", ""));
				}
			}
			else {
				rootCategory = getCategory(cid);
			}
		}
		
		return rootCategory;
	}

	/**
	 * @param cid category Id
	 * @return category instance
	 */
	public Category getCategory(String cid) {
		if (Application.isInternalCategory()) {
			return Application.getCategoryMap().get(cid);
		}
		else {
			return CategoryModel.getInstance().getCategory(cid);
		}
	}

	/**
	 * @return category list (top)
	 * @throws Exception if an error occurs
	 */
	public List<Category> getCategoryTopList() throws Exception {
		Category rg = getRootCategory();
		if (rg != null) {
			return rg.getChilds();
		}
		return null;
	}

//	@SuppressWarnings({ "rawtypes", "unchecked" })
	public List getKeywordList() throws Exception {
		return Collections.EMPTY_LIST;
//		Object o = getCache().get(GC.KEYWORDS_CACHE_KEY);
//		if (o instanceof List) {
//			return (List)o;
//		}
//		
//		List kl = YahooAPI.getShoppingAPI().keywordRanking();
//		getCache().put(GC.KEYWORDS_CACHE_KEY, kl);
//
//		return kl;
	}
	
	@Deprecated
	public void hitKeyword(String word) throws Exception {
		TaskQueueOptions tqo = new TaskQueueOptions();
		tqo.setUrl("/task/keyword_hits");
		tqo.getParams().put("word", word);
		
		TaskQueueFactory.getInstance().getDefaultQueue().add(tqo);
	}
}
