package squirrels.affiliate.webservice.rakuten;

import java.util.ArrayList;
import java.util.List;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import nuts.core.lang.NumberUtils;

import squirrels.affiliate.model.CategoryModel;
import squirrels.affiliate.model.bean.Category;

/**
 * Genre
 */
@SuppressWarnings("serial")
public class RakutenGenre extends CategoryModel {
	protected static final Long ROOT_ID = 0L;

	private ShoppingAPI shoppingAPI = RakutenAPI.getShoppingAPI();
	
	/**
	 * Constructor
	 */
	public RakutenGenre() {
		super();
	}
	/**
	 * @return the childs
	 */
	@Override
	public List<Category> getChilds() {
		if (childs == null) {
			gerenSearch(NumberUtils.toLong(id));
		}
		return childs;
	}

	/**
	 * @return the children
	 */
	@Override
	public List<Category> getChildren() {
		if (childs == null) {
			gerenSearch(NumberUtils.toLong(id));
		}
		return childs;
	}

	/**
	 * @return category
	 */
	public Category getRootCategory() {
		return getCategory(ROOT_ID);
	}

	private Category getCategory(Long cid) {
		Category c = getCache().get(cid);
		if (c == null) {
			c = gerenSearch(cid);
		}
		return c;
	}
	
	/**
	 * @param cid category Id
	 * @return category
	 */
	public Category getCategory(String cid) {
		return getCategory(NumberUtils.toLong(cid));
	}

	private RakutenGenre createGenre(JSONObject jo, RakutenGenre parent) {
		Long gid = jo.getLong("genreId");
		RakutenGenre g = (RakutenGenre)getCache().get(gid);
		if (g == null) {
			g = new RakutenGenre();
		}
		g.setId(gid.toString());
		g.setName(jo.optString("genreName"));
		g.setLevel(jo.optInt("genreLevel"));
		if (parent != null) {
			g.setParentId(parent.getId());
			g.setParent(parent);
		}
		getCache().put(gid, g);
		return g;
	}

	private synchronized CategoryModel gerenSearch(Long gid) {
		if (gid == null || gid < ROOT_ID) {
			return null;
		}
		
		JSONObject result = shoppingAPI.genreSearch(gid);
		if (result == null) {
			return null;
		}

		RakutenGenre gCurrent = null;
		if (gid == ROOT_ID) {
			gCurrent = new RakutenGenre();
			gCurrent.id = ROOT_ID.toString();
			gCurrent.name = "root";
			gCurrent.level = 0;
			getCache().put(gid, gCurrent);
		}
		else {
			JSONArray current = result.getJSONArray("current");
			if (current.size() > 0) {
				gCurrent = createGenre(current.getJSONObject(0), null);
				if (gCurrent.getLevel() > 1) {
					RakutenGenre[] gParents = new RakutenGenre[gCurrent.getLevel()];
					gParents[gCurrent.getLevel() - 1] = gCurrent;

					JSONArray parent = result.getJSONArray("parent");
					for (int i = 0; i < parent.size(); i++) {
						RakutenGenre g = createGenre(parent.getJSONObject(i), null);
						gParents[g.getLevel() - 1] = g;
					}
					for (int i = gParents.length - 1; i > 0; i--) {
						RakutenGenre g = gParents[i];
						RakutenGenre gp = gParents[i - 1];
						g.setParentId(gp.id);
						g.setParent(gp);
					}
				}				
			}
		}
		
		List<Category> cs = new ArrayList<Category>();
		JSONArray child = result.getJSONArray("child");
		for (int i = 0; i < child.size(); i++) {
			JSONObject jc = child.getJSONObject(i);
			RakutenGenre g = createGenre(jc, gCurrent);
			cs.add(g);
		}
		
		gCurrent.childs = cs;
		gCurrent.children = cs;

		return gCurrent;
	}

}

