/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.webservice.rakuten;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

import net.sf.json.JSONObject;

import nuts.core.lang.StringUtils;
import nuts.core.net.HttpClientAgent;
import nuts.core.servlet.URLHelper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 */
public class ShoppingAPI extends RakutenAPI {
	private static final Log log = LogFactory.getLog(ShoppingAPI.class);
	
	private JSONObject doJsonService(Map<String, Object> params) {
		return doJsonService(params, false);
	}
	
	@SuppressWarnings("unchecked")
	private JSONObject doJsonService(Map<String, Object> params, boolean noCache) {
		StringBuilder link = new StringBuilder();
		link.append(getWsuri());
		
		TreeMap<String, Object> sps = new TreeMap<String, Object>(params);
		URLHelper.buildParametersString(sps, link);
		String url = link.toString();
		
		String res = null;
		JSONObject jo = null;

		if (!noCache) {
			res = (String)getCache().get(url);
		}

		try {
			if (res == null) {
				log.debug(url);
				
				HttpClientAgent hca = new HttpClientAgent();
				
				hca.doGet(url);

				res = hca.getResponseText();
				if (StringUtils.isEmpty(res)) {
					return null;
				}
				
				jo = JSONObject.fromObject(res);
				if (log.isTraceEnabled()) {
					log.trace(jo.toString(2));
				}
			}
			else if (res.length() < 1) {
				return null;
			}
			else {
				jo = JSONObject.fromObject(res);
			}
			
			String status = jo.getJSONObject("Header").getString("Status");
			if ("Success".equals(status)) {
				if (!noCache) {
					getCache().put(url, res);
				}
				return jo;
			}
			else if ("NotFound".equals(status)) {
				if (!noCache) {
					getCache().put(url, "");
				}
				return null;
			}
			else {
				log.warn("RESPONSE STATUS ERROR: " + status + "\r\n" + url + "\r\n" + res);
				return null;
			}
		}
		catch (Exception e) {
			log.warn("URL FETCH ERROR: " + url + "\r\n" + res, e);
		}
		return null;
	}

	public JSONObject genreSearch(long genreId) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("developerId", getDeveloperId());
		params.put("operation", "GenreSearch");
		params.put("version", "2007-04-11");
		params.put("genreId", genreId);

		JSONObject jo = doJsonService(params, true);
		if (jo != null) {
			JSONObject result = jo.getJSONObject("Body").getJSONObject("GenreSearch");
			return result;
		}
		return null;
	}

	public JSONObject itemCodeSearch(String itemCode) {
		Map<String, Object> params = new HashMap<String, Object>();
		
		params.put("developerId", getDeveloperId());
//		params.put("affiliateId", getAffiliateId());
		params.put("operation", "ItemCodeSearch");
		params.put("version", "2010-08-05");
		params.put("itemCode", itemCode);
		
		JSONObject jo = doJsonService(params);
		if (jo != null) {
			JSONObject result = jo.getJSONObject("Body").getJSONObject("ItemCodeSearch");
			return result;
		}
		return null;
	}

	public JSONObject itemSearch(Map<String, Object> params) {
		params.put("developerId", getDeveloperId());
//		params.put("affiliateId", getAffiliateId());
		params.put("operation", "ItemSearch");
		params.put("version", "2010-09-15");
		
		JSONObject jo = doJsonService(params);
		if (jo != null) {
			JSONObject result = jo.getJSONObject("Body").getJSONObject("ItemSearch");
			return result;
		}
		return null;
	}

	public JSONObject itemRanking() {
		return itemRanking(0);
	}
	
	public JSONObject itemRanking(long genreId) {
		Map<String, Object> params = new HashMap<String, Object>();

		params.put("developerId", getDeveloperId());
//		params.put("affiliateId", getAffiliateId());
		params.put("operation", "ItemRanking");
		params.put("version", "2010-08-05");
		if (genreId > 0) {
			params.put("genreId", genreId);
		}
		
		JSONObject jo = doJsonService(params);
		if (jo != null) {
			JSONObject result = jo.getJSONObject("Body").getJSONObject("ItemRanking");
			return result;
		}
		return null;
	}
}
