/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.webservice.yahoojp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import net.sf.json.JSONObject;

import nuts.core.lang.StringUtils;
import nuts.core.net.HttpClientAgent;
import nuts.core.servlet.URLHelper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 */
public class ShoppingAPI extends YahooAPI {
	private static final Log log = LogFactory.getLog(ShoppingAPI.class);
	
	private JSONObject doJsonService(String api, Map<String, Object> params, boolean affiliate) {
		return doJsonService(api, params, false, false);
	}
	
	private JSONObject doJsonService(String api, Map<String, Object> params, boolean affiliate, boolean noCache) {
		StringBuilder link = new StringBuilder();

		link.append(api);
		
		TreeMap<String, Object> sps = new TreeMap<String, Object>(params);
		URLHelper.buildParametersString(sps, link);
		String url = link.toString();
		
		String res = null;
		JSONObject jo = null;

		if (!noCache) {
			res = (String)getCache().get(url);
		}

		try {
			if (res == null) {
				link.setLength(0);
				link.append(getWsuri()).append(api);
				
				sps.put("appid", getApplicationId());
				if (affiliate) {
					sps.put("affiliate_type", "yid");
					sps.put("affiliate_id", getAffiliateId());
				}
				URLHelper.buildParametersString(sps, link);
				
				url = link.toString();
				log.debug(url);
				
				HttpClientAgent hca = new HttpClientAgent();
				
				hca.doGet(url);

				res = hca.getResponseText();
				if (StringUtils.isEmpty(res)) {
					throw new Exception("Empty response body");
				}

				if (hca.getResonseStatusCode() != 200) {
					throw new Exception("Response status code error: " + hca.getResonseStatusCode());
				}
				
				jo = JSONObject.fromObject(res);
				if (log.isTraceEnabled()) {
					log.trace(jo.toString(2));
				}
			}
			else if (res.length() < 1) {
				return null;
			}
			else {
				jo = JSONObject.fromObject(res);
			}
		}
		catch (Exception e) {
			log.warn("URL FETCH ERROR: " + url + "\r\n" + res, e);
		}
		return jo;
	}

	public JSONObject categorySearch(long cid) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("category_id", cid);

		JSONObject jo = doJsonService("categorySearch", params, false);
		if (jo != null) {
			try {
				JSONObject result = jo.getJSONObject("ResultSet")
						.getJSONObject("0").getJSONObject("Result")
						.getJSONObject("Categories");
				return result;
			}
			catch (Throwable ex) {
			}
		}
		return null;
	}

	public JSONObject itemCodeSearch(String itemCode) {
		Map<String, Object> params = new HashMap<String, Object>();
		
		params.put("itemcode", itemCode);
		params.put("responsegroup", "medium");
		
		JSONObject jo = doJsonService("itemLookup", params, true);
		if (jo != null) {
			JSONObject result = jo.getJSONObject("Body").getJSONObject("ItemCodeSearch");
			return result;
		}
		return null;
	}

	public JSONObject itemSearch(Map<String, Object> params) {
		params.put("affiliateId", getAffiliateId());
		
		JSONObject jo = doJsonService("itemSearch", params, true);
		if (jo != null) {
			try {
				JSONObject result = jo.getJSONObject("ResultSet").getJSONObject("0").getJSONObject("Result");
				return result;
			}
			catch (Throwable ex) {
				log.warn("categoryRanking", ex);
			}
		}
		return null;
	}

	public List<String> keywordRanking() {
		int hits = 100;
		
		List<String> keys = new ArrayList<String>();
		
		Map<String, Object> params = new HashMap<String, Object>();

		params.put("type", "ranking");
		params.put("hits", hits);

		JSONObject jo = doJsonService("queryRanking", params, false, true);
		if (jo != null) {
			try {
				JSONObject result = jo.getJSONObject("ResultSet").getJSONObject("0").getJSONObject("Result");
				for (int i = 0; i < hits; i++) {
					String v = result.getJSONObject(String.valueOf(i)).getString("Query");
					if (v.length() < 20) {
						keys.add(v);
						if (keys.size() >= 20) {
							break;
						}
					}
				}
			}
			catch (Throwable ex) {
				log.warn("keywordRanking", ex);
			}
		}
		return keys;
	}
	
	public JSONObject itemRanking() {
		return categoryRanking(YahooCategory.ROOT_ID);
	}
	
	public JSONObject categoryRanking(long cid) {
		Map<String, Object> params = new HashMap<String, Object>();

		if (cid > YahooCategory.ROOT_ID) {
			params.put("category_id", cid);
		}
		
		JSONObject jo = doJsonService("categoryRanking", params, false);
		if (jo != null) {
			try {
				JSONObject result = jo.getJSONObject("ResultSet").getJSONObject("0").getJSONObject("Result");
				return result;
			}
			catch (Throwable ex) {
				log.warn("categoryRanking", ex);
			}
		}
		return null;
	}
}
