/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.webservice.yahoojp;

import java.util.Map;

import org.apache.commons.lang.StringUtils;



/**
 */
public class YahooAPI {
	private static Map cache;
	private static String wsuri = "http://shopping.yahooapis.jp/ShoppingWebService/V1/json/";
	private static String[] applicationIds;
	private static String affiliateId;
	public static String ID = "y";

	/**
	 * @param cache the cache to set
	 */
	public static void setCache(Map cache) {
		YahooAPI.cache = cache;
	}

	/**
	 * @return the cache
	 */
	public static Map getCache() {
		return cache;
	}

	/**
	 * @return the wsuri
	 */
	public static String getWsuri() {
		return wsuri;
	}

	/**
	 * @param wsuri the wsuri to set
	 */
	public static void setWsuri(String wsuri) {
		YahooAPI.wsuri = wsuri;
	}

	private static int aid = 0;
	
	/**
	 * @return the applicationId
	 */
	public static String getApplicationId() {
		if (applicationIds.length < 2) {
			return applicationIds[0];
		}

		aid++;
		if (aid >= applicationIds.length) {
			aid = 0;
		}
		return applicationIds[aid];
	}

	/**
	 * @param applicationId the applicationId to set
	 */
	public static void setApplicationId(String applicationId) {
		YahooAPI.applicationIds = StringUtils.split(applicationId);
	}

	/**
	 * @return the affiliateId
	 */
	public static String getAffiliateId() {
		return affiliateId;
	}

	/**
	 * @param affiliateId the affiliateId to set
	 */
	public static void setAffiliateId(String affiliateId) {
		YahooAPI.affiliateId = affiliateId;
	}
	
	public static ShoppingAPI getShoppingAPI() {
		return new ShoppingAPI();
	}
}
