package squirrels.affiliate.webservice.yahoojp;

import java.util.ArrayList;
import java.util.List;

import net.sf.json.JSONObject;

import nuts.core.lang.NumberUtils;

import squirrels.affiliate.model.CategoryModel;
import squirrels.affiliate.model.bean.Category;

/**
 */
@SuppressWarnings("serial")
public class YahooCategory extends CategoryModel {
	protected static final Long ROOT_ID = 1L;

	private ShoppingAPI shoppingAPI = YahooAPI.getShoppingAPI();
	
	/**
	 * Constructor
	 */
	public YahooCategory() {
		super();
	}
	/**
	 * @return the childs
	 */
	@Override
	public List<Category> getChilds() {
		if (childs == null) {
			categorySearch(NumberUtils.toLong(id));
		}
		return childs;
	}

	/**
	 * @return the children
	 */
	@Override
	public List<Category> getChildren() {
		if (childs == null) {
			categorySearch(NumberUtils.toLong(id));
		}
		return childs;
	}

	/**
	 * @return category
	 */
	public Category getRootCategory() {
		return getCategory(ROOT_ID.toString());
	}

	/**
	 * @param cid category Id
	 * @return category
	 */
	private Category getCategory(Long cid) {
		Category c = getCache().get(cid);
		if (c == null) {
			c = categorySearch(cid);
		}
		return c;
	}

	/**
	 * @param cid category Id
	 * @return category
	 */
	public Category getCategory(String cid) {
		return getCategory(NumberUtils.toLong(cid));
	}

	private YahooCategory createCategory(JSONObject jo, YahooCategory parent) {
		Long cid = jo.getLong("Id");
		YahooCategory c = (YahooCategory)getCache().get(cid);
		if (c == null) {
			c = new YahooCategory();
		}
		c.setId(cid.toString());
		c.setName(jo.getJSONObject("Title").getString("Short"));
		c.setLevel(0);
		
		if (jo.has("Path")) {
			JSONObject path = jo.getJSONObject("Path");
			for (int i = 0; ; i++) {
				String n = String.valueOf(i);
				if (!path.has(n)) {
					break;
				}
				JSONObject ji = path.getJSONObject(n);
				if (cid.toString().equals(ji.getString("Id"))) {
					int depth = NumberUtils.toInt(ji.getJSONObject("_attributes").getString("depth"));
					c.setLevel(depth - 1);
					break;
				}
			}
		}
		else if (parent != null) {
			c.setLevel(parent.getLevel() + 1);
		}

		if (parent != null) {
			c.setParentId(parent.getId());
			c.setParent(parent);
		}

		getCache().put(cid, c);
		return c;
	}

	private synchronized CategoryModel categorySearch(Long cid) {
		if (cid == null || cid < ROOT_ID) {
			return null;
		}
		
		JSONObject result = shoppingAPI.categorySearch(cid);
		if (result == null) {
			return null;
		}

		JSONObject current = result.getJSONObject("Current");
		if (current == null) {
			return null;
		}
		
		YahooCategory cCurrent = createCategory(current, null);
		
		List<Category> cs = new ArrayList<Category>();
		JSONObject children = result.optJSONObject("Children");
		if (children != null) {
			for (int i = 0; ; i++) {
				String n = String.valueOf(i);
				if (!children.has(n)) {
					break;
				}

				JSONObject jc = children.getJSONObject(n);
				YahooCategory c = createCategory(jc, cCurrent);
				cs.add(c);
			}
		}
		
		cCurrent.childs = cs;
		cCurrent.children = cs;

		return cCurrent;
	}

}

