package squirrels.affiliate.webservice.yahoojp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import nuts.core.lang.NumberUtils;
import nuts.core.lang.StringUtils;

import squirrels.affiliate.model.ItemModel;
import squirrels.affiliate.model.bean.Item;


/**
 * RakutenItem
 */
@SuppressWarnings("serial")
public class YahooItem extends ItemModel {
	/**
	 * Constructor
	 */
	public YahooItem() {
		super();
	}

	private YahooItem createItem(JSONObject jo) {
		YahooItem yi = new YahooItem();

		if (jo.has("Code")) {
			yi.setId(jo.getString("Code"));
		}
		yi.setName(jo.getString("Name"));
		
		if (jo.has("Image")) {
			JSONObject j = jo.getJSONObject("Image");
			//TODO
//			yi.setSmallImageUrl(j.getString("Small"));
//			yi.setMediumImageUrl(j.getString("Medium"));
		}
		if (jo.has("Store")) {
			JSONObject j = jo.getJSONObject("Store");
			yi.setId(j.getString("Id"));
			yi.setName(j.getString("Name"));
		}
		if (jo.has("_attributes")) {
			JSONObject j = jo.getJSONObject("_attributes");
//TODO			yi.setRank(j.getInt("rank"));
		}
		
		getCache().put(yi.getId(), yi);
		
		return yi;
	}
	
	public Item getItem(String code) {
		YahooItem item = (YahooItem)getCache().get(code);
		if (item == null) {
			JSONObject jo = YahooAPI.getShoppingAPI().itemCodeSearch(code);
			if (jo != null) {
				//TODO
				JSONArray items = jo.getJSONObject("Items").getJSONArray("Item");
				if (!items.isEmpty()) {
					item = createItem(jo);
					getCache().put(item.getId(), item);
				}
			}
		}
		return item;
	}
	
	@SuppressWarnings("unchecked")
	public Result search(String genreId, String keyword, String sort, boolean asc, int page, int limit) {
		Result result = new Result();
		//TODO
		Map<String, Object> params = new HashMap<String, Object>();
		if (StringUtils.isNotEmpty(genreId)) {
			params.put("genreId", genreId);
		}
		if (StringUtils.isNotEmpty(keyword)) {
			params.put("keyword", keyword);
		}
		params.put("sort", sort);
		params.put("page", page);
		params.put("hits", limit);

		JSONObject jo = YahooAPI.getShoppingAPI().itemSearch(params);
		if (jo != null) {
			result.setCount(jo.getInt("count"));
			JSONArray items = jo.getJSONObject("Items").getJSONArray("Item");
			result.setItems((List<Item>)JSONArray.toCollection(items, YahooItem.class));
			for (Item i : result.getItems()) {
				getCache().put(i.getId(), i);
			}
		}
		
		return result;
	}

	public List<Item> ranking(String cateId) {
		List<Item> items = new ArrayList<Item>();

		Long genreId = NumberUtils.toLong(cateId, 0L);
		JSONObject jo = YahooAPI.getShoppingAPI().categoryRanking(genreId);
		if (jo != null) {
			for (int i = 0; ; i++) {
				String n = String.valueOf(i);
				if (!jo.has(n)) {
					break;
				}
				
				JSONObject ji = jo.getJSONObject(n);
				YahooItem yi = createItem(ji);
				items.add(yi);
			}
		}
		return items;
	}
}

