<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
	<div class="item-block-wrap" id="${i.id!}">
		<div class="item-block">
			<div class="item-num">
				<#if _rank?? && _rank>
					<div class="item-rank"><@n.text name="label-vrank"><@s.param>${i_index + 1}</@s.param></@n.text></div>
				<#else>
					${pg.s + i_index + 1}.
				</#if>
			</div>
			<div class="item-image">
				<a class="item-icon" href="${base}/item/${i.id!}" target="_blank" rel="nofollow"><img src="<#if i.imageUrl?has_content>${i.imageUrl}<#else>${base}/images/no-img.jpg</#if>"/></a>
			</div>
			<div class="item-data">
				<div class="item-title">
					<a class="item-name" href="${base}/item/${i.id!}" target="_blank" rel="nofollow">${i.name?html}</a> <span class="item-catchcopy">${(i.catchcopy!)?html}</span>
				</div>
				<div class="item-pblock">
					<span class="item-price"><@n.text name="format-price"><@s.param value="${i.price!}"/></@n.text></span>
					<span class="item-pinfo">
					( <@n.text name="label-taxinc-${i.taxIncluded?string}"/>
					 | <@n.text name="label-freeship-${i.freeShipping?string}"/>
					 | <span class="item-point"><@n.text name="label-point"/>${i.pointRate!}%</span>
				<#if i.creditcardPay!false>
					 | <img class="item-cc" src="${base}/images/cir_credit_ok.gif"/>
				</#if>
					) 
					</span>
				</div>
				<div class="item-review">
					<span class="item-review-count"><@n.text name="label-review-count"/> ${i.reviewCount!}</span>
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					<span class="item-review-rate"><@n.text name="label-review-rate"/>
						<#list 1 .. (i.reviewRate!0)?floor as n>
							<img src="${static}/nuts/images/s.gif" class="n-icon n-icon-star"/>
						</#list>
					</span>
				</div>
			</div>
		</div>
	</div>
	<#if i_has_next><div class="hr"></div></#if>
