/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate;

import java.util.HashMap;
import java.util.Map;

import nuts.aems.WebApplet;
import nuts.exts.xwork2.util.LocalizedTextUtils;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;

import squirrels.affiliate.model.CategoryModel;
import squirrels.affiliate.model.ItemModel;
import squirrels.affiliate.model.bean.Category;
import squirrels.affiliate.webservice.rakuten.RakutenAPI;
import squirrels.affiliate.webservice.rakuten.RakutenGenre;
import squirrels.affiliate.webservice.rakuten.RakutenItem;
import squirrels.affiliate.webservice.yahoojp.YahooAPI;
import squirrels.affiliate.webservice.yahoojp.YahooCategory;
import squirrels.affiliate.webservice.yahoojp.YahooItem;

/**
 * Application
 */
public class Application extends WebApplet {

	private static boolean internalCategory;
	
	private static FileObject categoryImagesDir;

	private static Map<String, Category> categoryMap = new HashMap<String, Category>();

	public static String WSID = "";
	
	/**
	 * @return the internalCategory
	 */
	public static boolean isInternalCategory() {
		return internalCategory;
	}

	/**
	 * @param internalCategory the internalCategory to set
	 */
	public static void setInternalCategory(boolean internalCategory) {
		Application.internalCategory = internalCategory;
	}

	/**
	 * @return the categoryImagesDir
	 */
	public static FileObject getCategoryImagesDir() {
		return categoryImagesDir;
	}

	/**
	 * @param categoryImagesDir the categoryImagesDir to set
	 */
	public static void setCategoryImagesDir(FileObject categoryImagesDir) {
		Application.categoryImagesDir = categoryImagesDir;
	}

	/**
	 * @return the categoryMap
	 */
	public static Map<String, Category> getCategoryMap() {
		return categoryMap;
	}

	/**
	 * @param categoryMap the categoryMap to set
	 */
	public static void setCategoryMap(Map<String, Category> categoryMap) {
		Application.categoryMap = categoryMap;
	}

	/**
	 * initialize
	 */
	@Override
	protected void initialize() throws Exception {
		super.initialize();

		initDatabaseResourcesLoader();
		
		initDatabaseTemplateLoader();

		initActionPermits();

		addDefaultResource();
		
		onResourceLoaded();
	}

	private void addDefaultResource() throws Exception {
		LocalizedTextUtils.addDefaultResourceBundle(getClass().getName() + "Resource");
	}
	
	@Override
	public void onResourceLoaded() throws Exception {
		super.onResourceLoaded();
		
		internalCategory = getPropertyAsBoolean("category.internal");
		categoryImagesDir = VFS.getManager().resolveFile(getPropertyAsPath("category.images"));

		RakutenAPI.setCache(cache);
		RakutenAPI.setAffiliateId(LocalizedTextUtils.findDefaultText("rakuten-affiliateId"));
		RakutenAPI.setDeveloperId(LocalizedTextUtils.findDefaultText("rakuten-developerId"));

		YahooAPI.setCache(cache);
		YahooAPI.setAffiliateId(LocalizedTextUtils.findDefaultText("yahoojp-affiliateId"));
		YahooAPI.setApplicationId(LocalizedTextUtils.findDefaultText("yahoojp-applicationId"));
		
		CategoryModel.initCache();
		ItemModel.initCache();
		
		String site = LocalizedTextUtils.findDefaultText("affiliate-site");
		if ("yahoojp".equals(site)) {
			WSID = YahooAPI.ID;
			CategoryModel.setInstance(new YahooCategory());
			ItemModel.setInstance(new YahooItem());
		}
		else {
			WSID = RakutenAPI.ID;
			CategoryModel.setInstance(new RakutenGenre());
			ItemModel.setInstance(new RakutenItem());
		}
	}
}
