/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.action;

import squirrels.affiliate.model.CategoryModel;
import squirrels.affiliate.model.ItemModel;
import squirrels.affiliate.util.ActionConsts;
import squirrels.affiliate.util.ActionUtils;


/**
 * AbstractAction.
 */
@SuppressWarnings("serial")
public abstract class AbstractAction extends nuts.aems.action.AbstractAction {

	/**
	 * Constructor
	 */
	public AbstractAction() {
	}

	/**
	 * @return the utils
	 */
	public ActionUtils utils() {
		return (ActionUtils)super.getUtils();
	}

	/**
	 * @return the consts
	 */
	public ActionConsts consts() {
		return (ActionConsts)super.getConsts();
	}

	protected CategoryModel getCategoryModel() {
		return CategoryModel.getInstance();
	}

	protected ItemModel getItemModel() {
		return ItemModel.getInstance();
	}
}
