/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.action;

import java.io.FileReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.core.io.CsvReader;
import nuts.core.io.IOUtils;
import nuts.core.servlet.HttpServletSupport;
import nuts.exts.struts2.util.StrutsContextUtils;


/**
 */
@SuppressWarnings("serial")
public class SitemapAction extends AbstractAction {

	/**
	 * execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		HttpServletRequest req = StrutsContextUtils.getServletRequest();
		HttpServletResponse res = StrutsContextUtils.getServletResponse();
		
		HttpServletSupport hss = new HttpServletSupport(req, res);
		hss.setCharset("UTF-8");
		hss.setContentType("text/xml");
		hss.writeResponseHeader();

		String today = new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
		String site = req.getServerName();
		String cate = utils().getCatePkg();

		PrintWriter pw = res.getWriter();

		pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		pw.println("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">");

		pw.print("<url>");
		pw.print("<loc>http://");
		pw.print(site);
		pw.print("</loc>");
		pw.print("<lastmod>");
		pw.print(today);
		pw.print("</lastmod>");
		pw.print("<changefreq>daily</changefreq>");
		pw.print("<priority>1.0</priority>");
		pw.println("</url>");

		String path = StrutsContextUtils.getServletContext().getRealPath("/WEB-INF/sitemap.csv");
		CsvReader cr = null;
		try {
			cr = new CsvReader(new FileReader(path));

			List<String> ss;
			while ((ss = cr.readNext()) != null) {
				pw.print("<url>");
				pw.print("<loc>http://");
				pw.print(site);
				pw.print("/");
				pw.print(cate);
				pw.print("/");
				pw.print(ss.get(0));
				pw.print("</loc>");
				pw.print("<lastmod>");
				pw.print(today);
				pw.print("</lastmod>");
				pw.print("<changefreq>daily</changefreq>");
				pw.print("<priority>");
				pw.print(ss.get(1));
				pw.print("</priority>");
				pw.println("</url>");
			}
		}
		catch (Exception e) {
			log.error("[WARN] sitemap", e);
		}
		finally {
			IOUtils.closeQuietly(cr);
		}
		
		pw.println("</urlset>");
		return NONE;
	}
}
