/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.action.admin;

import java.util.Arrays;
import java.util.Calendar;

import nuts.aems.model.bean.CommonBean;
import nuts.aems.model.bean.User;
import nuts.core.orm.dao.QueryParameter;

import squirrels.affiliate.action.AbstractModelDrivenAction;
import squirrels.affiliate.constant.RC;


/**
 * @param <T> data type
 * @param <E> example type
 */
@SuppressWarnings("serial")
public abstract class AbstractAdminModelDrivenAction<T extends CommonBean, E extends QueryParameter> 
	extends AbstractModelDrivenAction<T, E> {

	/**
	 * checkUpdated
	 * @param data data
	 * @param srcData source data
	 * @return true if check successfully
	 * @throws Exception if an error occurs
	 */
	@Override
	protected boolean checkUpdated(T data, T srcData) throws Exception {
		if (srcData.beUpdated(data)) {
			data.setUusid(srcData.getUusid());
			data.setUtime(srcData.getUtime());
			addActionWarning(getText(RC.ERROR_DATA_IS_UPDATED,
					Arrays.asList(new Object[] { srcData.getUtime(), srcData.getUusid() })));
			return false;
		}
		return true;
	}

	/**
	 * startInsert
	 * @param data data
	 * @throws Exception if an error occurs
	 */
	@Override
	protected void startInsert(T data) throws Exception {
		super.startInsert(data);

		User user = utils().getLoginUser();

		if (data.getInvalid() == null) {
			data.setInvalid(false);
		}
		data.setUusid(user.getId());
		data.setUtime(Calendar.getInstance().getTime());
	}

	/**
	 * startUpdate
	 * @param data data
	 * @param srcData srcData
	 * @throws Exception if an error occurs
	 */
	@Override
	protected void startUpdate(T data, T srcData) throws Exception {
		super.startUpdate(data, srcData);

		User user = utils().getLoginUser();

		if (data.getInvalid() == null) {
			data.setInvalid(false);
		}
		data.setUusid(user.getId());
		data.setUtime(Calendar.getInstance().getTime());
	}
}
