/*
 * This file is part of Nuts.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.action.admin;

import java.util.List;

import nuts.core.orm.dao.DataAccessSession;

import squirrels.affiliate.model.bean.Category;
import squirrels.affiliate.model.dao.CategoryDAO;
import squirrels.affiliate.model.example.CategoryExample;



/**
 */
@SuppressWarnings("serial")
public class CategorySitemapAction extends AbstractAdminAction {
	private List<Category> list;
	
	public CategorySitemapAction() {
	}

	/**
	 * @return the list
	 */
	public List<Category> getList() {
		return list;
	}

	/**
	 * @param list the list to set
	 */
	public void setList(List<Category> list) {
		this.list = list;
	}

	public String execute() throws Exception {
		DataAccessSession das = getDataAccessSession();

		CategoryDAO cdao = new CategoryDAO(das);
		
		CategoryExample cexp = cdao.createExample();
		
		cexp.level().between(1, 4).level().asc().parentId().asc();
		
		list = cdao.selectByExample(cexp);

		return SUCCESS;
	}
}
