/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.action.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import nuts.aems.interceptor.MemCacheInterceptor;

import org.apache.commons.lang.StringUtils;

import squirrels.affiliate.Application;
import squirrels.affiliate.constant.AC;
import squirrels.affiliate.constant.RC;
import squirrels.affiliate.model.bean.Category;
import squirrels.affiliate.model.dao.CategoryDAO;
import squirrels.affiliate.model.example.CategoryExample;

/**
 */
@SuppressWarnings("serial")
public class CategoryAction extends AbstractTaskAction {

	private static boolean processing = false;

	private boolean reset = true;

	/**
	 * @return the reset
	 */
	public boolean isReset() {
		return reset;
	}

	/**
	 * @param reset the reset to set
	 */
	public void setReset(boolean reset) {
		this.reset = reset;
	}
	
	/**
	 * load
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String load() throws Exception {
		if (processing) {
			addActionMessage(getText(RC.MESSAGE_PROCESSING));
		}
		else {
			try {
				processing = true;
				removeApplicationError(AC.CATEGORY_RELOAD);
				removeApplicationMessage(AC.CATEGORY_RELOAD);

				loadCategory();
				
				addActionMessage(getText(RC.MESSAGE_PROCESSED));
			}
			catch (Exception e) {
				addApplicationError(AC.CATEGORY_RELOAD, 
						getText(RC.ERROR_CATEGORY_RELOAD, new String[] { e.getMessage() }));
			}
			finally {
				processing = false;
			}
		}
		return SUCCESS;
	}

	/**
	 * @throws Exception if an error occurs
	 */
	private void loadCategory() throws Exception {
		log.debug("Loading Category ...");

		CategoryDAO dao = new CategoryDAO(getDataAccessSession());
		CategoryExample cexp = dao.createExample();
		cexp.vendor().equalTo(Application.WSID).invalid().isFalse();

		Map<String, Category> categoryMap = new HashMap<String, Category>();
		List<Category> categoryList = dao.selectByExample(cexp);
		for (Category c : categoryList) {
			c.setId(StringUtils.removeStart(c.getId(), Application.WSID));
		}
		
		for (Category c : categoryMap.values()) {
			if (c.getParentId() != null) {
				Category cp = categoryMap.get(c.getParentId());
				if (cp != null) {
					if (!c.beInvalid()) {
						if (cp.getChilds() == null) {
							cp.setChilds(new ArrayList<Category>());
						}
						if (!cp.getChilds().contains(c)) {
							cp.getChilds().add(c);
						}
					}
					if (cp.getChildren() == null) {
						cp.setChildren(new ArrayList<Category>());
					}
					if (!cp.getChildren().contains(c)) {
						cp.getChildren().add(c);
					}
					c.setParent(cp);
				}
				else {
					log.error("[WARN] Can't find the parent Category(parentId:" + c.getParentId() + ")!");
				}
			}
		}

		Application.setCategoryMap(categoryMap);

		MemCacheInterceptor.setCacheReloadTime(AC.CATEGORY_RELOAD, reset);
	}
}
