/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.action.task;

import squirrels.affiliate.Application;
import squirrels.affiliate.constant.RC;
import squirrels.affiliate.model.CategoryModel;

/**
 */
@SuppressWarnings("serial")
public class GenreAction extends AbstractTaskAction {

	private static final String RELOADING = "genre.reloading";

	private boolean reset = true;

	/**
	 * @return the reset
	 */
	public boolean isReset() {
		return reset;
	}

	/**
	 * @param reset the reset to set
	 */
	public void setReset(boolean reset) {
		this.reset = reset;
	}
	
	/**
	 * load
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	@SuppressWarnings("unchecked")
	public String load() throws Exception {
		if (Boolean.TRUE.equals(Application.get().getCache().get(RELOADING))) {
			addActionMessage(getText(RC.MESSAGE_PROCESSING));
		}
		else {
			try {
				Application.get().getCache().put(RELOADING, Boolean.TRUE);
				
				CategoryModel.initCache();

				addActionMessage(getText(RC.MESSAGE_PROCESSED));
			}
			catch (Throwable e) {
				log.error("[WARN] Failed to load genre", e);
			}
			finally {
				Application.get().getCache().remove(RELOADING);
			}
		}
		return SUCCESS;
	}
}
