package squirrels.affiliate.webservice.rakuten;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import nuts.core.lang.NumberUtils;
import nuts.core.lang.StringUtils;

import squirrels.affiliate.model.ItemModel;
import squirrels.affiliate.model.bean.Item;


/**
 * RakutenItem
 */
@SuppressWarnings("serial")
public class RakutenItem extends ItemModel {
	/**
	 * Constructor
	 */
	public RakutenItem() {
		super();
	}

	private RakutenItem createItem(JSONObject jo) {
		RakutenItem item = new RakutenItem();
		
		item.setId(jo.optString("itemCode"));
		item.setName(jo.optString("itemName"));
		item.setCatchcopy(jo.optString("catchcopy"));
		item.setHasImage(1 == jo.optInt("imageFlag"));
		item.setSmallImageUrl(jo.optString("smallImageUrl"));
		item.setMediumImageUrl(jo.optString("mediumImageUrl"));
		item.setPrice(BigDecimal.valueOf(jo.optDouble("itemPrice")));
		item.setPointRate(jo.optInt("pointRate"));
		item.setTaxIncluded(1 == jo.optInt("taxFlag"));
		item.setFreeShipping(1 == jo.optInt("postageFlag"));
		item.setCreditcardPay(1 == jo.optInt("creditCardFlag"));
		item.setReviewCount(jo.optInt("reviewCount"));
		item.setReviewRate(BigDecimal.valueOf(jo.optDouble("reviewAverage")));
		item.setItemUrl(jo.optString("affiliateUrl"));
		item.setContent(jo.optString("itemCaption"));
		item.setShopId(jo.optString("shopCode"));
		item.setShopName(jo.optString("shopName"));
		item.setShopUrl(jo.optString("shopUrl"));
		
		return item;
	}
	
	public Item getItem(String code) {
		RakutenItem item = (RakutenItem)getCache().get(code);
		if (item == null) {
			JSONObject jo = RakutenAPI.getShoppingAPI().itemCodeSearch(code);
			if (jo != null) {
				JSONArray items = jo.getJSONObject("Items").getJSONArray("Item");
				if (!items.isEmpty()) {
					item = createItem(items.getJSONObject(0));
					getCache().put(item.getId(), item);
				}
			}
		}
		return item;
	}
	
	public Result search(String genreId, String keyword, String sort, int page, int limit) {
		Result result = new Result();
		
		Map<String, Object> params = new HashMap<String, Object>();
		if (StringUtils.isNotEmpty(genreId)) {
			params.put("genreId", genreId);
		}
		if (StringUtils.isNotEmpty(keyword)) {
			params.put("keyword", keyword);
		}
		params.put("sort", sort);
		params.put("page", page);
		params.put("hits", limit);

		JSONObject jo = RakutenAPI.getShoppingAPI().itemSearch(params);
		if (jo != null) {
			result.setCount(jo.getInt("count"));
			JSONArray ja = jo.getJSONObject("Items").getJSONArray("Item");
			for (int i = 0; i < ja.size(); i++) {
				Item item = createItem(ja.getJSONObject(i));
				getCache().put(item.getId(), item);
				result.getItems().add(item);
			}
		}
		
		return result;
	}

	public List<Item> ranking(String cateId) {
		List<Item> items = new ArrayList<Item>();

		Long genreId = NumberUtils.toLong(cateId, 0L);
		JSONObject jo = RakutenAPI.getShoppingAPI().itemRanking(genreId);
		if (jo != null) {
			JSONArray ja = jo.getJSONObject("Items").getJSONArray("Item");
			for (int i = 0; i < ja.size(); i++) {
				Item item = createItem(ja.getJSONObject(i));
				getCache().put(item.getId(), item);
				items.add(item);
			}
		}
		return items;
	}
}

