<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<tr>
	<td class="n-td-label"><@n.text name="images"/>:</td>
	<td class="n-td-input" colspan="2">
	<#if inputResult>
		<table id="cateimg_file_box"><tr>
			<td><input type="checkbox" class="checkbox" id="cateimg_resize"/></td>
			<td><label for="cateimg_resize"><@n.text name="label-resize"/></label></td>
			<td class="sep"></td> 
			<td><input type="file" id="cateimg_file"/></td>
			<td id="cateimg_file_info"></td>
		</tr></table>
		<table id="cateimg_uploading" style="display: none"><tr>
			<td><@n.text name="message-file-uploading"/></td>
			<td><img src="${static}/nuts/images/loader/snake.gif"/></td>
			<td><div class="progressbar" style="width:150px; height:12px;"></div></td>
		</tr></table>
		<div id="cateimg_prompt"></div>
	</#if>
		<div class="cateimg-list">
		<#if imageList?has_content>
			<#list imageList as i>
				<div class="cateimg-item<#if i.display> ui-state-highlight</#if>">
				<#if i.name?has_content>
					<input type="hidden" class="cateimg-name" name="images[${i_index?c}].name" value="${i.name?html}"/>
					<@n.url var="_url_" action='ci' namespace='/images'><@s.param name="cid">${d.id?c}</@s.param><@s.param name="cin">${i.name}</@s.param></@n.url>
					<a href="${_url_}" title="${i.name?html}"><img src="${_url_}"/></a>
				<#elseif i.temp?has_content>
					<input type="hidden" class="cateimg-name" name="images[${i_index?c}].temp" value="${i.temp?html}"/>
					<@n.url var="_url_" action='id' namespace='/images'><@s.param name="fn">${i.temp}</@s.param></@n.url>
					<a href="${_url_}" title="${i.temp?html}"><img src="${_url_}"/></a>
				</#if>
					<table class="cateimg-tb"><tr>
					<#if inputResult || confirmMethodResult>
					<#if i.name?has_content>
						<td><input type="checkbox" class="cateimg-delete" id="cateimgs_${i_index?c}a" name="images[${i_index?c}].action" value="D"<#if 'D' == i.action!> checked="checked"</#if>
							/><label for="cateimgs_${i_index?c}a"><@n.text name="button-delete"/></label>
						</td>
					<#elseif i.temp?has_content>
						<td><input type="checkbox" class="cateimg-insert" id="cateimgs_${i_index?c}a" name="images[${i_index?c}].action" value="I"<#if 'I' == i.action!> checked="checked"</#if>
							/><label for="cateimgs_${i_index?c}a"><@n.text name="button-insert"/></label>
						</td>
					</#if>
						<td align="right"><input type="checkbox" class="cateimg-icon" id="cateimgs_${i_index?c}d" name="images[${i_index?c}].display" value="true"<#if i.display> checked="checked"</#if>
							/><label for="cateimgs_${i_index?c}d"><@n.text name="button-icon"/></label>
						</td>
					</#if>
					</tr></table>
				</div>
			</#list>
		</#if>
		</div>
	
		<script type="text/javascript"><!--
			$(function() {
				var items = <#if images??>${images.size()?c}<#else>0</#if>;
				var progress = 0;
				var timer = null;
				var ogconf = { 
				    target: '#cateimg-gallery', 
				    expose: '#f1f1f1' 
				};
				
				function clearTimer() {
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
				}
				
				function checkDelete() {
					var $ci = $(this).closest('.cateimg-item').find('.cateimg-icon');
					if (this.checked) {
						$ci.attr({
							'checked': false,
							'disabled': true
						})
						.triggerHandler('change');
					}
					else {
						$ci.attr({
							'disabled': false
						});
					}
				}
				
				function checkInsert() {
					var $ci = $(this).closest('.cateimg-item').find('.cateimg-icon');
					if (this.checked) {
						$ci.attr({
							'disabled': false
						});
					}
					else {
						$ci.attr({
							'checked': false,
							'disabled': true
						})
						.triggerHandler('change');
					}
				}

				function checkIcon() {
					var c = this;
					if (c.checked) {
						$('#category_d_icon').val(
							$(c).closest('.cateimg-item')
								.addClass('ui-state-highlight')
								.find('.cateimg-name')
									.val()
						);
						$('.cateimg-list .cateimg-icon').each(function() {
							if (c != this) {
								this.checked = false;
								$(this).closest('.cateimg-item').removeClass('ui-state-highlight');
							}
						});
					}
				}
				
				function uploadImage() {
					progress = 0;
					$('#cateimg_uploading .progressbar').progressbar('value', progress);

					$('#cateimg_file_box').hide();
					$('#cateimg_file_info').html('');
					$('#cateimg_uploading').show();
					
					$('#cateimg_prompt').html('');

					timer = setInterval(function() {
						progress += 1;

						$('#cateimg_uploading .progressbar').progressbar('value', progress);
						
						if (progress >= 90) {
							clearTimer();
						}
					}, 20);

					var data = null;
					if ($('#cateimg_resize').attr('checked')) {
						data = { 
							scale: ${consts.imageScaleMap['M']}
						};
					}

					$.ajaf({
						url: '<@n.url action="iu" namespace="/images"/>',
						file: {
							'image': '#cateimg_file'
						},
						data: data,
						dataType: 'json',
						success: function(d) {
							progress = 100;
							$('#cateimg_uploading')
								.children('.progressbar').progressbar('value', progress).end()
								.hide();
							$('#cateimg_file_box').show();
							$('#cateimg_file').val('');
							if (d.success) {
								$('#cateimg_file_info')
									.css('color', 'navy')
									.html('<em class="ui-icon ui-icon-check n-fleft"></em><span></span>')
									.children('span').text(d.image.fileName);
								
								var u = '<@n.url action='id' namespace='/images'/>?fn=' + encodeURIComponent(d.image.saveName);
								var n = d.image.saveName.escapeHtml();
								var s = $('.cateimg-list');
								var a = $('<div class="cateimg-item">'
									+ '<input type="hidden" class="cateimg-name" name="images[' + items + '].temp" value="' + n + '"/>'
									+ '<a href="' + u + '" title="' + n + '"><img src="' + u + '"></a>'
									+ '<table class="cateimg-tb"><tr>'
									+ '<td>'
										+ '<input type="checkbox" class="cateimg-insert" id="cateimgs_' + items + 'a" name="images[' + items + '].action" value="I" checked="checked"/>'
										+ '<label for="cateimgs_' + items + 'a"><@n.text name="button-add"/></label>'
									+ '</td>'
									+ '<td align="right">'
										+ '<input type="checkbox" class="cateimg-icon" id="cateimgs_' + items + 'd" checked="checked"/>'
										+ '<label for="cateimgs_' + items + 'd"><@n.text name="button-icon"/></label>'
									+ '</td>'
									+ '</tr></table>'
									+ '</div>');

								items++;

								s.prepend(a);

								a.find('.cateimg-icon').change(checkIcon).change();
								a.find('.cateimg-insert').change(checkInsert);

								$('.cateimg-list a').lightBox();
							}
							else {
								$('#cateimg_file_info')
									.css('color', 'red')
									.html('<em class="ui-icon ui-icon-close n-fleft"></em><span></span>')
									.children('span').text(d.image.fileName);
								nuts.prompt({ container: '#cateimg_prompt' }).add(d);
							}
						},
						error: function(xhr, status, e) {
							$('#cateimg_uploading').hide();
							$('#cateimg_file_box').show();
							$('#cateimg_file').val('');
							nuts.prompt({ container: '#cateimg_prompt' }).add( 
								'<@n.text name="error-file-upload"/><br/>'	+ (e ? e.message : (xhr ? xhr.responseText : status)),
								'error'
							);
						}
					});
				}
				
				$('.cateimg-list a').lightBox();

				$('#cateimg_uploading .progressbar').progressbar();

				$('#cateimg_file').change(function() { setTimeout(uploadImage, 10); });
				
				$('.cateimg-list')
					.find('.cateimg-icon').change(checkIcon).end()
					.find('.cateimg-insert').change(checkInsert).end()
					.find('.cateimg-delete').change(checkDelete).end();
			});
		--></script>
	</td>
</tr>
