<#--
/*
 * This file is part of Nuts.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title>Category Retrieve</title>
</head>

<body>

<div class="n-sect" id="a_categoryretrieve">
	<div class="n-sect-head">
		<h3 class="n-sect-title">Category Retrieve</h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>
		
		<@n.form id="categoryre" class="n-eform" theme="nxhtml" onsubmit="return false;">
			<@n.submit icon="n-icon-arrow_switch" onclick="return doRetrieve();">Retrieve</@n.submit>
		</@n.form>

		<div class="hr"></div>

		<div>
			<@n.submit icon="n-icon-stop" onclick="doStop()">stop</@n.submit>
			<@n.submit icon="n-icon-bullet_go" onclick="doPeek()">peek</@n.submit>
		</div>
		
		<br/>
		<div id="categoryre_t"></div>
		
		<br/>
		<div id="categoryre_i">
		</div>
		<br/>
		<br/>

		<script type="text/javascript">
			var $hr;
			var pms = [];

			function doStop() {
				var data = {
					__decorator: 'none'
				};

				$.ajaf({
					url: "<@n.url action='categoryre_stop'/>",
					data: data,
					success: function(data) {
						$('#categoryre_t').html('<pre>' + data.formatXml().escapeHtml() + '</pre>');
					},
					error: function(xhr, status, e) {
						$('#categoryre_t').html('<div class="error">' + String.escapeHtml(xhr.responseText) + '</div>');
					}
				});
			}
			
			var peek;
			function doPeek() {
				if (peek) {
					clearInterval(peek);
					peek = null;
					$('#categoryre_t').empty();
				}
				else {
					peek = setInterval(function() {
						var data = {
							__decorator: 'none'
						};
		
						$.ajaf({
							url: "<@n.url action='categoryre_peek'/>",
							data: data,
							success: function(data) {
								$('#categoryre_t').html('<pre>' + data.formatXml().escapeHtml() + '</pre>');
							},
							error: function(xhr, status, e) {
								$('#categoryre_t').html('<div class="error">' + String.escapeHtml(xhr.responseText) + '</div>');
							}
						});
					}, 1000);
				}
			}
			
			function doRetrieve() {
				doWork("<@n.url action='categoryre_retrieve'/>");
				return false;
			}
			
			function doWork(url) {
				$('#categoryre').loadmask();
				$('#categoryre_t').empty();
				
				$hr = $('<div class="hr"></div>').appendTo($('#categoryre_i').empty());
				pms = [];

				var data = {
					__decorator: 'none',
					error: 'parent.retrieve_error("{0}");',
					process: 'parent.retrieve_process({0}, "{1}");',
					success: 'parent.retrieve_success("{0}");'
				};
				
				$.ajaf({
					url: url,
					data: data,
					success: function(d) {
						$('#categoryre').unloadmask();
					},
					error: function(xhr, status, e) {
						$('#categoryre').unloadmask();
						$hr.after('<div class="error">' + String.escapeHtml(xhr.responseText) + '</div>');
					}
				});
			}
			
			function retrieve_error(msg) {
				$hr.after('<pre class="error">' + String.escapeHtml(msg).replace(/\r\n/g, '<br/>') + '</pre>');
			}
			
			function retrieve_success(msg) {
				msg = '{0} items processed.'.replace('{0}', msg);
				$hr.after('<div>' + String.escapeHtml(msg).replace(/\r\n/g, '<br/>') + '</div>');
			}
			
			function retrieve_process(progress, msg) {
				var $m = $('<div>' + String.escapeHtml(progress + '. ' + msg).replace(/\r\n/g, '<br/>') + '</div>');

				$hr.after($m);
				pms.push($m);

				while (pms.length > 20) {
					pms.shift().remove();
				}
			}
		</script>
	</div>
</div>

</body>
</html>
