<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<meta http-equiv="description" content="${utils.siteDescrip?html}"></meta>
	<meta http-equiv="keywords" content="${utils.siteKeyword?html} <#if category??>,${category.name?html}</#if>"></meta>
	<title><#if qq.k?has_content>
<@n.text name="title-search"><@s.param value="qq.k"/></@n.text><#rt/>
		<#else>
<@n.text name="title-page"><@s.param><#if category??>${category.name?html}</#if></@s.param></@n.text><#rt/>
		</#if>
	</title>
</head>

<body>

<div class="n-sect" id="a_item_list">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><#rt/>
			<#include "location.ftl"/>
		<#if qq.k?has_content>
			<@n.text name="title-search"><@s.param><span class="site-search-text">"${qq.k}"</span></@s.param></@n.text><#rt/>
		</#if>
		</h3>
	</div>
	<div class="n-sect-body">
		<@n.form id="item" method="get" theme="simple">
			<@n.hidden name="gid"/>
			<@n.hidden name="qq.k"/>
			<@n.hidden name="qq.t"/>
			<@n.hidden name="pg.s"/>
			<@n.hidden name="pg.l"/>
			<@n.hidden name="so.c"/>
			<@n.hidden name="so.d"/>
		</@n.form>

	<#if rankList?has_content><#assign _rank=true/>
		<div class="xhead"><@n.text name="label-rankList"/></div>
		<table id="rank_list"><tr>
		<th>
			<span class="prev"></span>
		</th>
		<td>
			<div class="item-hlist"><table class="item-cont" cellspacing="0" cellpadding="0"><tr>
			<#list rankList as i>
				<td><#include "item-thumb.ftl"/></td>
			</#list>
			</tr></table></div>
		</td>
		<th>
			<span class="next"></span>
		</th>
		</tr></table>
		<br/>
	</#if>

	<#if itemList?has_content><#assign _rank=false/>
		<div class="xhead"><@n.text name="label-itemList"/></div>

		<@n.url var="url">
			<@s.param name="gid" value="gid"/>
			<@s.param name="qq.k" value="qq.k"/>
			<@s.param name="qq.t" value="qq.t"/>
			<@s.param name="pg.l" value="pg.l"/>
			<@s.param name="so.c" value="so.c"/>
			<@s.param name="so.d" value="so.d"/>
		</@n.url>
		<#assign linkHref = url + "&amp;pg.s=?"/>

		<div class="item-vlist">
			<#include "item_list-tbar.ftl"/>
			<div class="hrt"></div>
	
			<#list itemList as i>
				<#include "item-block.ftl"/>
			</#list>
	
			<div class="hrb"></div>
			<#include "item_list-tbar.ftl"/>
		</div>
	</#if>
	</div>
</div>

</body>
</html>
