/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop;

import nuts.aems.WebApplet;
import nuts.exts.lucene.store.VFSDirectory;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

/**
 */
public class MyApplet extends WebApplet {
	protected static FileObject lucenePath;
	protected static Directory luceneDirectory;
	
	protected static void buildLuceneDirectory() throws Exception {
		FileSystemManager fsm = VFS.getManager();
		lucenePath = fsm.resolveFile(Application.get().getProperty("lucene.directory", "gae:///lucene"));
		luceneDirectory = new VFSDirectory(fsm, lucenePath);
	}
	
	/**
	 * @return the luceneIndexWriter
	 * @throws Exception 
	 */
	protected static IndexWriter getLuceneIndexWriter() throws Exception {
		IndexWriter writer = new IndexWriter(luceneDirectory,
				new StandardAnalyzer(Version.LUCENE_30), !lucenePath.exists(),
				IndexWriter.MaxFieldLength.LIMITED);
		writer.setMergeScheduler(new SerialMergeScheduler());
		MergePolicy mp = writer.getMergePolicy();
		if (mp instanceof LogByteSizeMergePolicy) {
			((LogByteSizeMergePolicy)mp).setMaxMergeMB(0.9);
		}
		else {
			mp = new LogByteSizeMergePolicy(writer);
			((LogByteSizeMergePolicy)mp).setMaxMergeMB(0.9);
			writer.setMergePolicy(mp);
		}
		return writer;
	}
}


