/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.Cookie;

import nuts.aems.model.bean.User;
import nuts.aems.model.dao.UserDAO;
import nuts.aems.model.example.UserExample;
import nuts.aems.model.metadata.UserMetaData;
import nuts.core.servlet.HttpServletUtils;
import nuts.core.util.Pager;
import nuts.core.util.Sorter;
import nuts.exts.struts2.util.StrutsContextUtils;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

import squirrels.ecshop.bean.RankCount;
import squirrels.ecshop.constant.GC;
import squirrels.ecshop.constant.RC;
import squirrels.ecshop.model.bean.GoodsComment;
import squirrels.ecshop.model.dao.GoodsCommentDAO;
import squirrels.ecshop.model.example.GoodsCommentExample;
import squirrels.ecshop.model.metadata.GoodsCommentMetaData;


/**
 * GoodsCommentAction
 */
@SuppressWarnings("serial")
public class GoodsCommentAction extends AbstractAction {

	/**
	 * DEFAULT_EXPIRES = 24H;
	 */
	private static final int DEFAULT_EXPIRES = 24 * 60 * 60;

	private GoodsComment data = new GoodsComment();
	
	private Pager pager = new Pager();

	private Sorter sorter = new Sorter();

	private Long goodsId;
	
	private List<GoodsComment> commentList;

	private Map<Long, User> commentUsers;
	
	private List<RankCount> rankList;

	private int average;
	
	private Boolean vote;
	
	private Long commentId;
	
	private boolean posted;

	/**
	 * @return the vote
	 */
	public Boolean getVote() {
		return vote;
	}

	/**
	 * @param vote the vote to set
	 */
	public void setVote(Boolean vote) {
		this.vote = vote;
	}

	/**
	 * @return the commentId
	 */
	public Long getCommentId() {
		return commentId;
	}

	/**
	 * @param commentId the commentId to set
	 */
	public void setCommentId(Long commentId) {
		this.commentId = commentId;
	}

	/**
	 * @return the goodsId
	 */
	public Long getGoodsId() {
		return goodsId;
	}

	/**
	 * @param goodsId the goodsId to set
	 */
	public void setGoodsId(Long goodsId) {
		this.goodsId = goodsId;
	}

	/**
	 * @return the list
	 */
	public List<GoodsComment> getCommentList() {
		return commentList;
	}

	/**
	 * @return the rankList
	 */
	public List<RankCount> getRankList() {
		return rankList;
	}

	/**
	 * @return the average
	 */
	public int getAverage() {
		return average;
	}

	/**
	 * @return the pager
	 */
	public Pager getPager() {
		return pager;
	}

	/**
	 * @param pager the pager to set
	 */
	public void setPager(Pager pager) {
		this.pager = pager;
	}

	/**
	 * @return the sorter
	 */
	public Sorter getSorter() {
		return sorter;
	}

	/**
	 * @param sorter the sorter to set
	 */
	public void setSorter(Sorter sorter) {
		this.sorter = sorter;
	}

	/**
	 * @return the posted
	 */
	public boolean isPosted() {
		return posted;
	}

	//-----------------------------------------------------------------------
	// short name
	//-----------------------------------------------------------------------
	/**
	 * @return the d
	 */
	public GoodsComment getD() {
		return data;
	}

	/**
	 * @return the pager
	 */
	public Pager getPg() {
		return pager;
	}

	/**
	 * @param pager the pager to set
	 */
	public void setPg(Pager pager) {
		this.pager = pager;
	}

	/**
	 * @return the sorter
	 */
	public Sorter getSo() {
		return sorter;
	}

	/**
	 * @param sorter the sorter to set
	 */
	public void setSo(Sorter sorter) {
		this.sorter = sorter;
	}

	/**
	 * @return the goodsId
	 */
	public Long getGid() {
		return goodsId;
	}

	/**
	 * @param goodsId the goodsId to set
	 */
	public void setGid(Long goodsId) {
		this.goodsId = goodsId;
	}

	/**
	 * @return the vote
	 */
	public Boolean getV() {
		return vote;
	}

	/**
	 * @param vote the vote to set
	 */
	public void setV(Boolean vote) {
		this.vote = vote;
	}

	/**
	 * @return the commentId
	 */
	public Long getCid() {
		return commentId;
	}

	/**
	 * @param commentId the commentId to set
	 */
	public void setCid(Long commentId) {
		this.commentId = commentId;
	}

    /**
     * @return ERROR
     */
	@Override
    public String getInputResultName() {
		if ("list".equals(utils().getActionMethod())) {
	    	return ERROR;
		}
    	return INPUT;
    }

	/**
	 * input
	 * @return INPUT
	 * @throws Exception if an error occurs
	 */
	public String input() throws Exception {
		if (data.getGoodsId() == null) {
			data.setGoodsId(goodsId);
		}
		return INPUT;
	}
	
	/**
	 * post 
	 * @return INPUT
	 * @throws Exception if an error occurs
	 */
	public String post() throws Exception {
		GoodsCommentDAO dao = new GoodsCommentDAO(getDataAccessSession());

		User user = utils().getLoginUser();
		if (user != null) {
			data.setUserId(user.getId());
		}
		
		data.setVoteOk(0);
		data.setVoteNo(0);
		data.setInvalid(false);
		data.setPtime(Calendar.getInstance().getTime());
		data.setCusid(GC.UNKNOWN_USID);
		data.setCtime(data.getPtime());
		data.setUusid(GC.UNKNOWN_USID);
		data.setUtime(data.getCtime());

		dao.insert(data);
		getDataAccessSession().commit();
		
		addActionMessage(getText("success-posted"));
		
		data.setTitle(null);
		data.setComment(null);
		
		posted = true;
		
		return INPUT;
	}
	
	/**
	 * list
	 * @return LIST
	 * @throws Exception if an error occurs
	 */
	public String list() throws Exception {
		data.setGoodsId(goodsId);
			
		utils().loadLimitParams(pager);
		utils().loadSorterParams(sorter);

		GoodsCommentDAO dao = new GoodsCommentDAO(getDataAccessSession());
		GoodsCommentExample example = dao.createExample();
	
		example.goodsId().equalTo(data.getGoodsId()).and().invalid().isFalse();
		example.getOrders().addOrder(getColumnByField(sorter.getColumn()), sorter.getDirection());
	
		pager.setTotal(dao.countByExample(example));
		pager.normalize();
		if (pager.getTotal() > 0) {
			example.setStart(pager.getStart());
			example.setLimit(pager.getLimit());
			commentList = (List<GoodsComment>)dao.selectByExample(example);
			loadCommentUsers();
		}

		utils().saveLimitParams(pager);
		utils().saveSorterParams(sorter);

		return LIST;
	}

	@SuppressWarnings("unchecked")
	private void loadCommentUsers() throws Exception {
		if (commentList.size() < 1) {
			return;
		}
		
		Set<Long> cids = new HashSet<Long>();
		for (GoodsComment c : commentList) {
			if (c.getUserId() != null) {
				cids.add(c.getUserId());
			}
		}
		if (CollectionUtils.isEmpty(cids)) {
			commentUsers = Collections.EMPTY_MAP;
		}
		else {
			UserDAO cdao = new UserDAO(getDataAccessSession());
			UserExample cexp = cdao.createExample();
			cexp.id().in(cids);
			commentUsers = (Map<Long, User>)cdao.selectMapByExample(cexp, UserMetaData.PN_ID);
		}
	}

	/**
	 * @param id user id
	 * @return user
	 */
	public User getCommentUser(Long id) {
		return commentUsers.get(id);
	}
	
	/**
	 * get column name by field
	 * @param field field
	 * @return column name
	 */
	private String getColumnByField(String field) {
		return GoodsCommentMetaData.getInstance().getColumnAlias(field);
	}

	/**
	 * vote
	 * @return "vote"
	 * @throws Exception if an error occurs
	 */
	public String vote() throws Exception {
		final String CN = "pcvs";
		String cv = "";
		
		Cookie cookie = HttpServletUtils.getCookie(StrutsContextUtils.getServletRequest(), CN);
		if (cookie != null) {
			cv = cookie.getValue(); 
		}
		
		String[] ids = StringUtils.split(cv, ',');
		if (!ArrayUtils.contains(ids, commentId.toString())) {
			GoodsCommentDAO gcDao = new GoodsCommentDAO(getDataAccessSession());
			
			GoodsComment gc = gcDao.selectByPrimaryKey(commentId);
			if (Boolean.FALSE.equals(vote)) {
				gc.setVoteNo(gc.getVoteNo() + 1);
			}
			else {
				gc.setVoteOk(gc.getVoteOk() + 1);
			}
			gcDao.updateByPrimaryKey(gc);
			getDataAccessSession().commit();

			if (StringUtils.isNotEmpty(cv)) {
				cv += ',';
			}
			cv += commentId.toString();

			Cookie c = new Cookie(CN, cv);
			c.setMaxAge(getTextAsInt(RC.VOTE_EXPIRES, DEFAULT_EXPIRES));
			StrutsContextUtils.getServletResponse().addCookie(c);
		}
		return "vote";
	}
}