/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import nuts.aems.model.bean.User;
import nuts.aems.model.dao.UserDAO;
import nuts.aems.model.example.UserExample;
import nuts.aems.model.metadata.UserMetaData;
import nuts.core.servlet.HttpServletUtils;
import nuts.core.servlet.URLHelper;
import nuts.core.util.Pager;
import nuts.core.util.Sorter;
import nuts.exts.struts2.util.StrutsContextUtils;
import nuts.exts.xwork2.util.ContextUtils;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import squirrels.ecshop.bean.RankCount;
import squirrels.ecshop.constant.GC;
import squirrels.ecshop.constant.RC;
import squirrels.ecshop.constant.VC;
import squirrels.ecshop.model.bean.GoodsReview;
import squirrels.ecshop.model.dao.GoodsReviewDAO;
import squirrels.ecshop.model.example.GoodsReviewExample;
import squirrels.ecshop.model.metadata.GoodsReviewMetaData;


/**
 * GoodsReviewAction
 */
@SuppressWarnings("serial")
public class GoodsReviewAction extends AbstractAction {

	/**
	 * DEFAULT_EXPIRES = 24H;
	 */
	private static final int DEFAULT_EXPIRES = 24 * 60 * 60;
	
	private GoodsReview data = new GoodsReview();
	
	private Pager pager = new Pager();

	private Sorter sorter = new Sorter();

	private Long goodsId;
	
	private List<GoodsReview> reviewList;
	
	private Map<Long, User> reviewUsers;
	
	private List<RankCount> rankList;

	private int average;
	
	private Boolean vote;
	
	private Long reviewId;
	
	private boolean posted;
	
	/**
	 * @return the goodsId
	 */
	public Long getGoodsId() {
		return goodsId;
	}

	/**
	 * @param goodsId the goodsId to set
	 */
	public void setGoodsId(Long goodsId) {
		this.goodsId = goodsId;
	}

	/**
	 * @return the reviewList
	 */
	public List<GoodsReview> getReviewList() {
		return reviewList;
	}

	/**
	 * @return the rankList
	 */
	public List<RankCount> getRankList() {
		return rankList;
	}

	/**
	 * @return the average
	 */
	public int getAverage() {
		return average;
	}

	/**
	 * @return the vote
	 */
	public Boolean getVote() {
		return vote;
	}

	/**
	 * @param vote the vote to set
	 */
	public void setVote(Boolean vote) {
		this.vote = vote;
	}

	/**
	 * @return the reviewId
	 */
	public Long getReviewId() {
		return reviewId;
	}

	/**
	 * @param reviewId the reviewId to set
	 */
	public void setReviewId(Long reviewId) {
		this.reviewId = reviewId;
	}

	/**
	 * @return the data
	 */
	public GoodsReview getData() {
		return data;
	}

	/**
	 * @return the pager
	 */
	public Pager getPager() {
		return pager;
	}

	/**
	 * @param pager the pager to set
	 */
	public void setPager(Pager pager) {
		this.pager = pager;
	}

	/**
	 * @return the sorter
	 */
	public Sorter getSorter() {
		return sorter;
	}

	/**
	 * @param sorter the sorter to set
	 */
	public void setSorter(Sorter sorter) {
		this.sorter = sorter;
	}


	/**
	 * @return the posted
	 */
	public boolean isPosted() {
		return posted;
	}

	//-----------------------------------------------------------------------
	// short name
	//-----------------------------------------------------------------------
	/**
	 * @return the data
	 */
	public GoodsReview getD() {
		return data;
	}

	/**
	 * @return the pager
	 */
	public Pager getPg() {
		return pager;
	}

	/**
	 * @param pager the pager to set
	 */
	public void setPg(Pager pager) {
		this.pager = pager;
	}

	/**
	 * @return the sorter
	 */
	public Sorter getSo() {
		return sorter;
	}

	/**
	 * @param sorter the sorter to set
	 */
	public void setSo(Sorter sorter) {
		this.sorter = sorter;
	}

	/**
	 * @return the vote
	 */
	public Boolean getV() {
		return vote;
	}

	/**
	 * @param vote the vote to set
	 */
	public void setV(Boolean vote) {
		this.vote = vote;
	}

	/**
	 * @return the reviewId
	 */
	public Long getRid() {
		return reviewId;
	}

	/**
	 * @param reviewId the reviewId to set
	 */
	public void setRid(Long reviewId) {
		this.reviewId = reviewId;
	}

	/**
	 * @return the goodsId
	 */
	public Long getGid() {
		return goodsId;
	}

	/**
	 * @param goodsId the goodsId to set
	 */
	public void setGid(Long goodsId) {
		this.goodsId = goodsId;
	}

    /**
     * @return ERROR
     */
	@Override
    public String getInputResultName() {
		if ("list".equals(utils().getActionMethod())) {
	    	return ERROR;
		}
    	return INPUT;
    }

	/**
	 * input
	 * @return INPUT
	 * @throws Exception if an error occurs
	 */
	public String input() throws Exception {
		if (data.getRank() == null) {
			data.setRank(VC.GOODS_REVIEW_RANK_DEFAULT);
		}
		if (data.getGoodsId() == null) {
			data.setGoodsId(goodsId);
		}
		return INPUT;
	}
	
	/**
	 * post 
	 * @return INPUT
	 * @throws Exception if an error occurs
	 */
	public String post() throws Exception {
		User user = utils().getLoginUser();

		if (user == null || StringUtils.isEmpty(user.getPassword())) {
			HttpServletRequest request = ServletActionContext.getRequest();
			String requestUrl = URLHelper.buildURL(request);
			ContextUtils.getValueStack().getContext().put("redirect", requestUrl);
			return LOGIN;
		}

		GoodsReviewDAO dao = new GoodsReviewDAO(getDataAccessSession());

		data.setUserId(user.getId());
		data.setVoteOk(0);
		data.setVoteNo(0);
		data.setInvalid(false);
		data.setPtime(Calendar.getInstance().getTime());
		data.setCusid(GC.UNKNOWN_USID);
		data.setCtime(data.getPtime());
		data.setUusid(GC.UNKNOWN_USID);
		data.setUtime(data.getCtime());

		dao.insert(data);
		getDataAccessSession().commit();
		
		addActionMessage(getText("success-posted"));
		
		data.setRank(VC.GOODS_REVIEW_RANK_DEFAULT);
		data.setTitle(null);
		data.setReview(null);
		
		posted = true;
		
		return INPUT;
	}
	
	/**
	 * list
	 * @return LIST
	 * @throws Exception if an error occurs
	 */
	public String list() throws Exception {
		data.setGoodsId(goodsId);
		
		utils().loadLimitParams(pager);
		utils().loadSorterParams(sorter);

		GoodsReviewDAO dao = new GoodsReviewDAO(getDataAccessSession());
		GoodsReviewExample example = new GoodsReviewExample();
	
		example.goodsId().equalTo(goodsId).and().invalid().isFalse();
		example.getOrders().addOrder(getColumnByField(sorter.getColumn()), sorter.getDirection());
	
		pager.setTotal(dao.countByExample(example));
		pager.normalize();
		if (pager.getTotal() > 0) {
			example.setStart(pager.getStart());
			example.setLimit(pager.getLimit());
			reviewList = (List<GoodsReview>)dao.selectByExample(example);
			loadReviewUsers();
			sumRankList();
		}

		utils().saveLimitParams(pager);
		utils().saveSorterParams(sorter);

		return LIST;
	}

	@SuppressWarnings("unchecked")
	private void loadReviewUsers() throws Exception {
		if (reviewList.size() < 1) {
			return;
		}
		
		Set<Long> cids = new HashSet<Long>();
		for (GoodsReview r : reviewList) {
			cids.add(r.getUserId());
		}

		if (CollectionUtils.isEmpty(cids)) {
			reviewUsers = Collections.EMPTY_MAP;
		}
		else {
			UserDAO udao = new UserDAO(getDataAccessSession());
			UserExample uexp = udao.createExample();
			uexp.id().in(cids);
			reviewUsers = (Map<Long, User>)udao.selectMapByExample(uexp, UserMetaData.PN_ID);
		}
	}

	/**
	 * @param id user id
	 * @return user
	 */
	public User getReviewUser(Long id) {
		return reviewUsers.get(id);
	}
	
	private void sumRankList() throws Exception {
		Map<String, String> ranks = consts().getReviewRankMap();
		rankList = new ArrayList<RankCount>(ranks.size());
		
		int total = 0;
		GoodsReviewDAO rdao = new GoodsReviewDAO(getDataAccessSession());
		for (Entry<String, String> en : ranks.entrySet()) {
			int i = Integer.parseInt(en.getKey());

			GoodsReviewExample rexp = rdao.createExample();
			rexp.goodsId().equalTo(goodsId).and().rank().equalTo(i);
			
			RankCount rc = new RankCount();
			rc.setRank(i);
			rc.setCount(rdao.countByExample(rexp));
			rc.setRate(0);
			rankList.add(rc);

			total += rc.getCont();
		}
		
		int sum = 0;
		for (RankCount rc : rankList) {
			if (rc.getCount() > 0) {
				sum += rc.getRank() * rc.getCount();
				rc.setRate(rc.getCount() * 100 / total);
			}
		}
		
		average = Math.round(sum / total);
	}
	
	/**
	 * get column name by field
	 * @param field field
	 * @return column name
	 */
	private String getColumnByField(String field) {
		return GoodsReviewMetaData.getInstance().getColumnAlias(field);
	}

	/**
	 * vote
	 * @return "vote"
	 * @throws Exception if an error occurs
	 */
	public String vote() throws Exception {
		final String CN = "grvs";
		String cv = "";
		
		Cookie cookie = HttpServletUtils.getCookie(StrutsContextUtils.getServletRequest(), CN);
		if (cookie != null) {
			cv = cookie.getValue(); 
		}
		
		String[] ids = StringUtils.split(cv, ',');
		if (!ArrayUtils.contains(ids, reviewId.toString())) {
			GoodsReviewDAO grDao = new GoodsReviewDAO(getDataAccessSession());
			
			GoodsReview gr = grDao.selectByPrimaryKey(reviewId);
			if (Boolean.FALSE.equals(vote)) {
				gr.setVoteNo(gr.getVoteNo() + 1);
			}
			else {
				gr.setVoteOk(gr.getVoteOk() + 1);
			}
			grDao.updateByPrimaryKey(gr);
			getDataAccessSession().commit();

			if (StringUtils.isNotEmpty(cv)) {
				cv += ',';
			}
			cv += reviewId.toString();

			Cookie c = new Cookie(CN, cv);
			c.setMaxAge(getTextAsInt(RC.VOTE_EXPIRES, DEFAULT_EXPIRES));
			StrutsContextUtils.getServletResponse().addCookie(c);
		}
		return "vote";
	}
}