/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action;

import javax.servlet.http.HttpServletResponse;

import nuts.core.lang.StringUtils;
import nuts.exts.struts2.util.StrutsContextUtils;
import nuts.exts.struts2.views.freemarker.FreemarkerUtils;



/**
 * HelpAction
 */
@SuppressWarnings("serial")
public class HelpAction extends AbstractAction {

	private String name;
	
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * execute
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		if (StringUtils.isNotEmpty(name)) {
			if (!FreemarkerUtils.hasTemplate("/help/" + name + ".ftl")) {
				StrutsContextUtils.getServletResponse().sendError(HttpServletResponse.SC_NOT_FOUND);
				return NONE;
			}
		}
		return SUCCESS;
	}

}
