/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.admin;

import java.util.Calendar;
import java.util.List;

import nuts.core.util.DateRange;

/**
 * ReportAction
 */
@SuppressWarnings("serial")
public class ReportAction extends AbstractAdminAction {

	private DateRange dateRange = new DateRange();

	private List dataList;
	
	/**
	 * @return the dateRange
	 */
	public DateRange getDr() {
		return dateRange;
	}

	/**
	 * @param dateRange the dateRange to set
	 */
	public void setDr(DateRange dateRange) {
		this.dateRange = dateRange;
	}

	/**
	 * @return the dataList
	 */
	public List getDataList() {
		return dataList;
	}

	/**
	 * Constructor
	 */
	public ReportAction() {
	}

	/**
	 * input
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String input() throws Exception {
		if (dateRange.getFrom() == null) {
			Calendar c = Calendar.getInstance();
			c.add(Calendar.MONTH, -1);
			c.set(Calendar.DAY_OF_MONTH, 1);
			dateRange.setFrom(c.getTime());
		}
		if (dateRange.getTo() == null) {
			Calendar c = Calendar.getInstance();
			dateRange.setTo(c.getTime());
		}
		return INPUT;
	}
	
	/**
	 * list
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String list() throws Exception {
		//TODO
		//dataList = getSqlMapClient().queryForList(ADMIN_REPORT_SUPPLY_AND_SOLD, dateRange);
        return SUCCESS;
    }

}
