/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.admin;

import java.util.List;

import nuts.aems.model.bean.User;

import squirrels.ecshop.model.dao.UserAddressDAO;
import squirrels.ecshop.model.dao.UserCreditCardDAO;
import squirrels.ecshop.model.dao.UserOrderDAO;
import squirrels.ecshop.model.example.UserAddressExample;
import squirrels.ecshop.model.example.UserCreditCardExample;
import squirrels.ecshop.model.example.UserOrderExample;



/**
 * UserExAction
 */
@SuppressWarnings("serial")
public class UserExAction extends nuts.aems.action.user.UserExAction {

	/**
	 * Constructor
	 */
	public UserExAction() {
		super();
	}
	
	/**
	 * checkOnDelete
	 * @param data data
	 * @param srcData srcData
	 * @return true if check success
	 * @throws Exception if an error occurs
	 */
	@Override
	protected boolean checkOnDelete(User data, User srcData) throws Exception {
		if (!super.checkOnDelete(data, srcData)) {
			return false;
		}

		UserOrderDAO odao = new UserOrderDAO(getDataAccessSession());
		UserOrderExample oexp = odao.createExample();
		oexp.userId().equalTo(data.getId());
		if (odao.countByExample(oexp) > 0) {
			addActionError(getText("error-delete-with-order"));
			return false;
		}
		return true;
	}

	/**
	 * startDelete
	 * @param data data
	 */
	@Override
	protected void startDelete(User data) throws Exception {
		super.startDelete(data);
		deleteUserData(data);
	}
	
	private void deleteUserData(User data) throws Exception {
		UserAddressDAO adao = new UserAddressDAO(getDataAccessSession());
		UserAddressExample aexp = adao.createExample();
		aexp.userId().equalTo(data.getId());
		adao.deleteByExample(aexp);
		
		UserCreditCardDAO cdao = new UserCreditCardDAO(getDataAccessSession());
		UserCreditCardExample cexp = cdao.createExample();
		cexp.userId().equalTo(data.getId());
		cdao.deleteByExample(cexp);
	}

	/**
	 * checkOnBulkDelete
	 * @param data data
	 * @return true - continue, false - skip
	 */
	@Override
	protected boolean checkOnBulkDelete(List<User> dataList) throws Exception {
		if (!super.checkOnBulkDelete(dataList)) {
			return false;
		}
		
		UserOrderDAO odao = new UserOrderDAO(getDataAccessSession());
		for (User c : dataList) {
			UserOrderExample oexp = odao.createExample();
			oexp.userId().equalTo(c.getId());
			if (odao.countByExample(oexp) > 0) {
				addActionError(getText("error-delete-with-order",
						new String[] { String.valueOf(c.getId()) }));
			}
		}

		return !hasErrors();
	}

	
	/**
	 * startBulkDelete
	 * @param data data
	 */
	@Override
	protected void startBulkDelete(List<User> dataList) throws Exception {
		super.startBulkDelete(dataList);
		
		for (User c : dataList) {
			deleteUserData(c);
		}
	}
}