/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.admin;

import squirrels.ecshop.action.admin.userorderitem.UserOrderItemAction;
import squirrels.ecshop.constant.VC;
import squirrels.ecshop.model.bean.UserOrder;
import squirrels.ecshop.model.bean.UserOrderItem;
import squirrels.ecshop.model.dao.UserOrderDAO;

/**
 * UserOrderItemExAction
 */
@SuppressWarnings("serial")
public class UserOrderItemExAction extends UserOrderItemAction {

	/**
	 * Constructor
	 */
	public UserOrderItemExAction() {
		super();
	}

	/**
	 * validate
	 */
	@Override
	public void validate() {
		try {
			if (getData() != null && getData().getUserOrderId() != null) {
				UserOrderDAO dao = new UserOrderDAO(getDataAccessSession());
				UserOrder co = dao.selectByPrimaryKey(getData().getUserOrderId());
				if (co != null && VC.ORDER_STATUS_FINISHED.equals(co.getStatus())) {
					addActionError(getText("error-order-finished"));
				}
			}
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * commitInsert
	 * @param data data
	 * @throws Exception  if an error occurs
	 */
	@Override
	protected void commitInsert(UserOrderItem data) throws Exception {
		if (!data.beInvalid()) {
			utils().daoUpdateGoodsOrderQuantity(getDataAccessSession(), data.getGoodsId(), data.getQuantity());
			utils().daoCalcUserOrderPrice(getDataAccessSession(), data.getUserOrderId());
		}
		super.commitInsert(data);
	}
	
	/**
	 * commitUpdate
	 * @param data data
	 * @param srcData source data
	 * @throws Exception  if an error occurs
	 */
	@Override
	protected void commitUpdate(UserOrderItem data, UserOrderItem srcData) throws Exception {
		if (data.getGoodsId().equals(srcData.getGoodsId())) {
			if (data.beInvalid() && !srcData.beInvalid()) {
				utils().daoUpdateGoodsOrderQuantity(getDataAccessSession(), srcData.getGoodsId(), -srcData.getQuantity());
			}
			else if (!data.beInvalid() && srcData.beInvalid()) {
				utils().daoUpdateGoodsOrderQuantity(getDataAccessSession(), srcData.getGoodsId(), srcData.getQuantity());
			}
			else if (!data.beInvalid() && !srcData.beInvalid()) {
				if (data.getQuantity() - srcData.getQuantity() != 0) {
					utils().daoUpdateGoodsOrderQuantity(getDataAccessSession(), srcData.getGoodsId(), data.getQuantity() - srcData.getQuantity());
				}
			}
		}
		else {
			utils().daoUpdateGoodsOrderQuantity(getDataAccessSession(), srcData.getGoodsId(), -srcData.getQuantity());
			utils().daoUpdateGoodsOrderQuantity(getDataAccessSession(), data.getGoodsId(), data.getQuantity());
		}
		
		utils().daoCalcUserOrderPrice(getDataAccessSession(), data.getUserOrderId());

		super.commitUpdate(data, srcData);
	}

	/**
	 * commitDelete
	 * @param data data
	 */
	@Override
	protected void commitDelete(UserOrderItem data) throws Exception {
		if (!data.beInvalid()) {
			utils().daoUpdateGoodsOrderQuantity(getDataAccessSession(), data.getGoodsId(), -data.getQuantity());
			utils().daoCalcUserOrderPrice(getDataAccessSession(), data.getUserOrderId());
		}

		super.commitDelete(data);
	}
}
