/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.images;

import java.io.InputStream;

import nuts.core.io.IOUtils;
import nuts.core.servlet.HttpServletSupport;
import nuts.exts.struts2.util.StrutsContextUtils;

import squirrels.ecshop.action.AbstractAction;


/**
 * Base Action for Image Download
 */
@SuppressWarnings("serial")
public abstract class AbstractImageDownloadAction extends AbstractAction {

	/**
	 * NOIMG = "noimg";
	 */
	protected final static String NOIMG = "noimg";

	/**
	 * imageName
	 */
	protected String imageName;

	/**
	 * imageType
	 */
	protected String imageType;

	/**
	 * imageSize
	 */
	protected int imageSize;
	
	/**
	 * imageStream
	 */
	protected InputStream imageStream;

	/**
	 * @return the imageName
	 */
	public String getImageName() {
		return imageName;
	}

	/**
	 * @param imageName the imageName to set
	 */
	public void setImageName(String imageName) {
		this.imageName = imageName;
	}

	/**
	 * @return the imageType
	 */
	public String getImageType() {
		if (imageType == null) {
			imageType = IOUtils.getContentTypeFor(imageName);
		}
		return imageType;
	}

	/**
	 * @param imageType the imageType to set
	 */
	public void setImageType(String imageType) {
		this.imageType = imageType;
	}

	/**
	 * @return the imageSize
	 */
	public int getImageSize() {
		return imageSize;
	}

	/**
	 * @param imageSize the imageSize to set
	 */
	public void setImageSize(int imageSize) {
		this.imageSize = imageSize;
	}

	/**
	 * @return the imageStream
	 */
	public InputStream getImageStream() {
		return imageStream;
	}

	/**
	 * @param imageStream the imageStream to set
	 */
	public void setImageStream(InputStream imageStream) {
		this.imageStream = imageStream;
	}

	/**
	 * execute
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		return NOIMG;
	}

	protected String success() throws Exception {
		HttpServletSupport hsrs = new HttpServletSupport(StrutsContextUtils.getServletRequest(), StrutsContextUtils.getServletResponse());
		
		hsrs.setContentLength(imageSize);
		hsrs.setFileName(imageName);
//		hsrs.setNoCache(true);

		hsrs.writeResponseHeader();
		hsrs.writeResponseData(imageStream);

		return NONE;
	}
}