/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.images;

import nuts.core.lang.NumberUtils;
import nuts.core.lang.StringUtils;

import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;

import squirrels.ecshop.model.bean.Category;


/**
 * CategoryImageAction
 */
@SuppressWarnings("serial")
public class CategoryImageAction extends AbstractImageDownloadAction {

	private String categoryId;

	/**
	 * @return the categoryId
	 */
	public String getCid() {
		return categoryId;
	}

	/**
	 * @param categoryId the categoryId to set
	 */
	public void setCid(String categoryId) {
		this.categoryId = categoryId;
	}

	/**
	 * @return the imageName
	 */
	public String getCin() {
		return imageName;
	}

	/**
	 * @param imageName the imageName to set
	 */
	public void setCin(String imageName) {
		this.imageName = imageName;
	}

	/**
	 * execute
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		Long cid = NumberUtils.toLong(categoryId);
		if (cid != null) {
			if (StringUtils.isEmpty(imageName)) {
				Category c = utils().getCategory(cid);
				if (c != null) {
					imageName = c.getIcon();
				}
			}
				
			if (StringUtils.isNotEmpty(imageName)) {
				FileObject fo = utils().getCategoryImagesPath(cid);
				if (fo.exists()) {
					FileObject fi = fo.resolveFile(imageName);
					if (fi.exists()) {
						FileContent fc = fi.getContent();
						imageSize = (int)fc.getSize();
						imageStream = fc.getInputStream();
						return success();
					}
				}
			}
		}
		return NOIMG;
	}
}