/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import squirrels.ecshop.constant.AC;
import squirrels.ecshop.constant.RC;
import squirrels.ecshop.interceptor.MemCacheExInterceptor;
import squirrels.ecshop.model.bean.Category;
import squirrels.ecshop.model.dao.CategoryDAO;
import squirrels.ecshop.model.example.CategoryExample;

/**
 */
@SuppressWarnings("serial")
public class CategoryAction extends AbstractTaskAction {

	private static boolean reloading = false;
	
	/**
	 * load
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String load() throws Exception {
		if (reloading) {
			addActionMessage(getText(WARNING_LOADING));
		}
		else {
			try {
				reloading = true;
				removeApplicationError(AC.CATEGORY_RELOAD);
				removeApplicationMessage(AC.CATEGORY_RELOAD);

				loadCategory();
				
				addActionMessage(getText(SUCCESS_LOADED));
			}
			catch (Exception e) {
				addApplicationError(AC.CATEGORY_RELOAD, 
						getText(RC.ERROR_CATEGORY_RELOAD, new String[] { e.getMessage() }));
			}
			finally {
				reloading = false;
			}
		}
		return SUCCESS;
	}

	/**
	 * @throws Exception if an error occurs
	 */
	private void loadCategory() throws Exception {
		log.debug("Loading Category ...");

		Map<Long, Category> categoryMap = new HashMap<Long, Category>();
		List<Category> categoryTop = new ArrayList<Category>();

		CategoryDAO dao = new CategoryDAO(getDataAccessSession());
		CategoryExample example = dao.createExample();

		List<Category> cl = dao.selectByExample(example);
		for (Category c : cl) {
			categoryMap.put(c.getId(), c);
		}
		
		for (Category c : cl) {
			if (c.getParentId() != null) {
				Category cp = categoryMap.get(c.getParentId());
				if (cp != null) {
					if (!c.beInvalid()) {
						if (cp.getChilds() == null) {
							cp.setChilds(new ArrayList<Category>());
						}
						if (!cp.getChilds().contains(c)) {
							cp.getChilds().add(c);
						}
					}
					if (cp.getChildren() == null) {
						cp.setChildren(new ArrayList<Category>());
					}
					if (!cp.getChildren().contains(c)) {
						cp.getChildren().add(c);
					}
					c.setParent(cp);
				}
				else {
					log.error("Can't find the parent Category(parentId:" + c.getParentId() + ")!");
				}
			}
		}

		for (Category c : cl) {
			if (c.getParentId() == null) {
				if (!c.getInvalid()) {
					categoryTop.add(c);
				}
			}
		}

		getApplication().put(AC.CATEGORY_MAP, categoryMap);
		getApplication().put(AC.CATEGORY_TOP_LIST, categoryTop);
		MemCacheExInterceptor.setCacheReloadTime(AC.CATEGORY_RELOAD, reset);
	}
}
