/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.task;

import java.util.List;

import squirrels.ecshop.constant.AC;
import squirrels.ecshop.model.bean.Goods;
import squirrels.ecshop.model.dao.GoodsDAO;
import squirrels.ecshop.model.example.GoodsExample;

/**
 */
@SuppressWarnings("serial")
public class GoodsAction extends AbstractTaskAction {

	/**
	 * bestsales
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String bestsales() throws Exception {
		log.debug("Loading Best Sales Goods ...");

		GoodsDAO dao = new GoodsDAO(getDataAccessSession());
		GoodsExample exp = dao.createExample();
		exp.invalid().isFalse()
			.soldQuantity().desc()
			.setLimit(getTextAsInt("max-bestsales", 10));
		List<Goods> list = dao.selectByExample(exp);
		getApplication().put(AC.GOODS_BEST_SALES, list);

		return SUCCESS;
	}
}
