/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.user;

import nuts.aems.model.bean.User;

import squirrels.ecshop.action.user.address.AddressAction;
import squirrels.ecshop.model.bean.UserAddress;
import squirrels.ecshop.model.example.UserAddressExample;



/**
 * AddressExAction
 */
@SuppressWarnings("serial")
public class AddressExAction extends AddressAction {

	/**
	 * Constructor
	 */
	public AddressExAction() {
		super();
	}

	/**
	 * prepareDefaultData
	 * @param data data
	 * @return data
	 */
	@Override
	protected UserAddress prepareDefaultData(UserAddress data)
			throws Exception {
		data = super.prepareDefaultData(data);
		User user = utils().getLoginUser();
		if (user != null) {
			data.setUserId(user.getId());
		}
		return data;
	}

	/**
	 * checkCommon
	 * @param data data
	 * @param srcData source data (null on insert)
	 * @return true if do something success
	 * @throws Exception if an error occurs
	 */
	@Override
	protected boolean checkCommon(UserAddress data, UserAddress srcData) throws Exception {
		if (!utils().getLoginUser().getId().equals(data.getUserId())) {
			throw utils().IllegalUserIdException(data.getUserId());
		}
		if (srcData != null &&
				!utils().getLoginUser().getId().equals(srcData.getUserId())) {
			throw utils().IllegalUserIdException(srcData.getUserId());
		}
		return true;
	}

	/**
	 * queryListByExample
	 * @param example example
	 */
	@Override
	protected void queryListByExample(UserAddressExample example) throws Exception {
		example.userId().equalTo(utils().getLoginUser().getId());
		super.queryListByExample(example);
	}

}