/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.user;

import nuts.aems.model.bean.User;

import squirrels.ecshop.action.user.goodsreview.GoodsReviewAction;
import squirrels.ecshop.constant.VC;
import squirrels.ecshop.model.bean.GoodsReview;
import squirrels.ecshop.model.bean.UserOrderItem;
import squirrels.ecshop.model.dao.UserOrderItemDAO;
import squirrels.ecshop.model.example.UserOrderItemExample;


/**
 * GoodsReviewExAction
 */
@SuppressWarnings("serial")
public class GoodsReviewExAction extends GoodsReviewAction {

	/**
	 * Constructor
	 */
	public GoodsReviewExAction() {
		super();
	}

	/**
	 * prepareDefaultData
	 * @param data data
	 * @return data
	 */
	@Override
	protected GoodsReview prepareDefaultData(GoodsReview data)
			throws Exception {
		data = super.prepareDefaultData(data);
		User user = utils().getLoginUser();
		if (user != null) {
			data.setUserId(user.getId());
		}
		return data;
	}

	@Override
	protected boolean checkOnInsert(GoodsReview data) throws Exception {
		if (userOrderItemId != null) {
			UserOrderItemDAO dao = new UserOrderItemDAO(getDataAccessSession());
			UserOrderItem coi = dao.selectByPrimaryKey(userOrderItemId);
			
			if (coi == null || !VC.ORDER_STATUS_FINISHED.equals(coi.getStatus())) {
				userOrderItemId = null;
			}
		}
		if (userOrderItemId == null) {
			User user = utils().getLoginUser();
			UserOrderItemDAO dao = new UserOrderItemDAO(getDataAccessSession());
			UserOrderItemExample example = dao.createExample();
			example.userId().equalTo(user.getId())
				.and().goodsId().equalTo(data.getGoodsId())
				.and().status().equalTo(VC.ORDER_STATUS_FINISHED)
				.and().reviewId().isNull();
			
			UserOrderItem coi = dao.selectOneByExample(example);
			if (coi == null) {
				addActionError(getText("error-need-buy"));
				return false;
			}
			userOrderItemId = coi.getId();
			if (userOrderItemId == null) {
				addActionError(getText("error-reviewed"));
				return false;
			}
		}
		return super.checkOnInsert(data);
	}

	/**
	 * commitInsert
	 * @param data data
	 * @throws Exception if an error occurs
	 */
	@Override
	protected void commitInsert(GoodsReview data) throws Exception {
		updateCOIReviewId(data);
		super.commitInsert(data);
	}

	private void updateCOIReviewId(GoodsReview data) throws Exception {
		UserOrderItem coi = new UserOrderItem();
		coi.setId(userOrderItemId);
		coi.setReviewId(data.getId());

		UserOrderItemDAO dao = new UserOrderItemDAO(getDataAccessSession());
		int i = dao.updateByPrimaryKeySelective(coi);
		if (i != 1) {
			throw new RuntimeException("Failed to update USER_ORDER_ITEM.REVIEW_ID. {id: " 
				+ coi.getId() + ", reviewId: " + coi.getReviewId() + "} COUNT: " + i);
		}
	}

}
