/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


/**
 * Report
 */
@SuppressWarnings("serial")
public class Report implements Serializable {

	private Date date;
	
	private BigDecimal supplyAmount;
	
	private BigDecimal soldAmount;

	/**
	 * @return the date
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @return the soldAmount
	 */
	public BigDecimal getSoldAmount() {
		return soldAmount;
	}

	/**
	 * @param soldAmount the soldAmount to set
	 */
	public void setSoldAmount(BigDecimal soldAmount) {
		this.soldAmount = soldAmount;
	}

	/**
	 * @return the supplyAmount
	 */
	public BigDecimal getSupplyAmount() {
		return supplyAmount;
	}

	/**
	 * @param supplyAmount the supplyAmount to set
	 */
	public void setSupplyAmount(BigDecimal supplyAmount) {
		this.supplyAmount = supplyAmount;
	}

	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append("date: ").append(date);
		sb.append(", ");
		sb.append("supplyAmount: ").append(supplyAmount);
		sb.append(", ");
		sb.append("soldAmount: ").append(soldAmount);
		sb.append(" }");

		return sb.toString();
	}
}