/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.interceptor;

import nuts.exts.xwork2.ActionSupport;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.PreResultListener;

/**
 */
@SuppressWarnings("serial")
public class RichFieldErrorInterceptor extends AbstractInterceptor {

	protected String actionError = "error-input";

	/**
	 * Constructor
	 */
	public RichFieldErrorInterceptor() {
	}

	/**
	 * @param actionError the actionError to set
	 */
	public void setActionError(String actionError) {
		this.actionError = actionError;
	}

	private static class ResultListener implements PreResultListener {

		private String actionError;

		public ResultListener(String actionError) {
			this.actionError = actionError;
		}

		public void beforeResult(ActionInvocation invocation, String resultCode) {
			Object action = invocation.getAction();
			if (action instanceof ActionSupport) {
				ActionSupport as = (ActionSupport)action;
				if (as.hasFieldErrors()) {
					as.addActionError(as.getText(actionError));
				}
			}
		}
	}
	
	/**
	 * Allows the Interceptor to do some processing on the request before and/or after the rest of
	 * the processing of the request by the {@link ActionInvocation} or to short-circuit the
	 * processing and just return a String return code.
	 * 
	 * @param actionInvocation the action invocation
	 * @return the return code, either returned from {@link ActionInvocation#invoke()}, or from the
	 *         interceptor itself.
	 * @throws Exception any system-level error, as defined in
	 *             {@link com.opensymphony.xwork2.Action#execute()}.
	 */
	public String intercept(ActionInvocation actionInvocation) throws Exception {
		actionInvocation.addPreResultListener(new ResultListener(actionError));
		return actionInvocation.invoke();
	}
}
