package squirrels.ecshop.util;

import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;

import nuts.aems.util.BaseActionConsts;
import nuts.exts.struts2.actions.CommonAction;

import squirrels.ecshop.constant.RC;

/**
 * TextConstants
 */
@SuppressWarnings("unchecked")
public class ActionConsts extends BaseActionConsts {
	/**
	 * Constructor
	 */
	public ActionConsts(CommonAction action) {
		super(action);
	}
	
	/**
	 * CREDIT_CARD_EXPIRE_M = { "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12" };
	 */
	public final static String[] CREDIT_CARD_EXPIRE_M = { "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12" };
	
	/**
	 * CREDIT_CARD_EXPIRE_Y_MAX = 15;
	 */
	public final static int CREDIT_CARD_EXPIRE_Y_MAX = 15; 

	/**
	 * @return credit card type map
	 */
	public Map<String, String> getCreditCardTypeMap() {
		return getTextAsMap(RC.CREDIT_CARD_TYPES);
	}

	/**
	 * @return credit card expire month map
	 */
	public Map<String, String> getCreditCardExpireMonthMap() {
		Map<String, String> map = new LinkedHashMap<String, String>();
		for (int i = 0; i < CREDIT_CARD_EXPIRE_M.length; i++) {
			map.put(CREDIT_CARD_EXPIRE_M[i], CREDIT_CARD_EXPIRE_M[i]);
		}
		return map;
	}
	
	/**
	 * @return credit card expire month array
	 */
	public String[] getCreditCardExpireMonthArray() {
		return CREDIT_CARD_EXPIRE_M;
	}
	
	/**
	 * @return credit card expire year map
	 */
	public Map<String, String> getCreditCardExpireYearMap() {
		int year = Calendar.getInstance().get(Calendar.YEAR);
		
		Map<String, String> map = new LinkedHashMap<String, String>();
		for (int i = 0; i < CREDIT_CARD_EXPIRE_Y_MAX; i++, year++) {
			map.put(String.valueOf(year), String.valueOf(year));
		}
		return map;
	}
	
	/**
	 * @return credit card expire year array
	 */
	public String[] getCreditCardExpireYearArray() {
		int year = Calendar.getInstance().get(Calendar.YEAR);

		String[] ary = new String[CREDIT_CARD_EXPIRE_Y_MAX];
		for (int i = 0; i < CREDIT_CARD_EXPIRE_Y_MAX; i++, year++) {
			ary[i] = String.valueOf(year);
		}
		return ary;
	}
	
	/**
	 * get goods image kind map
	 * @return map
	 */
	public Map<String, String> getOrderStatusMap() {
		return getTextAsMap(RC.ORDER_STATUS);
	}

	/**
	 * getDeliveryKindMap
	 * @return map
	 */
	public Map<String, String> getDeliveryKindMap() {
		return getTextAsMap(RC.DELIVERY_KINDS);
	}

	/**
	 * getDeliveryTimeMap
	 * @return map
	 */
	public Map<String, String> getDeliveryTimeMap() {
		return getTextAsMap(RC.DELIVERY_TIMES);
	}

	/**
	 * getPaymentKindMap
	 * @return map
	 */
	public Map<String, String> getPaymentKindMap() {
		return getTextAsMap(RC.PAYMENT_KINDS);
	}

	/**
	 * get review rank map
	 * @return map
	 */
	public Map<String, String> getReviewRankMap() {
		return getTextAsMap(RC.REVIEW_RANKS);
	}
	
	/**
	 * get goods language map
	 * @return map
	 */
	public Map<String, String> getGoodsLanguageMap() {
		return getTextAsMap(RC.GOODS_LANGUAGES);
	}
	
	/**
	 * get goods subtitle map
	 * @return map
	 */
	public Map<String, String> getGoodsSubtitleMap() {
		return getTextAsMap(RC.GOODS_SUBTITLES);
	}
	
	/**
	 * get goods format map
	 * @return map
	 */
	public Map<String, String> getGoodsFormatMap() {
		return getTextAsMap(RC.GOODS_FORMATS);
	}
	
	/**
	 * get goods target map
	 * @return map
	 */
	public Map<String, String> getGoodsTargetMap() {
		return getTextAsMap(RC.GOODS_TARGETS);
	}
	
	/**
	 * get goods target age map
	 * @return map
	 */
	public Map<String, String> getGoodsTargetAgeMap() {
		return getTextAsMap(RC.GOODS_TARGET_AGES);
	}

	/**
	 * get goods keyword kind map
	 * @return map
	 */
	public Map<String, String> getGoodsKeywordKindMap() {
		return getTextAsMap(RC.GOODS_KEYWORD_KINDS);
	}
	
	/**
	 * @return image scale map
	 */
	public Map<String, String> getImageScaleMap() {
		return getTextAsMap(RC.IMAGE_SCALES);
	}
}
