<#--
/*
 * This file is part of Nuts.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title>Goods Index</title>
</head>

<body>

<div class="n-sect" id="a_goodsindex">
	<div class="n-sect-head">
		<h3 class="n-sect-title">Goods Test</h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>
		
		<@n.form id="goodsindex" class="n-eform" theme="nxhtml" onsubmit="return false;">
			<@n.textfield name="start" label="start"/>
			<@n.textfield name="limit" label="limit"/>
			<@n.textfield name="words" label="words"/>
			<@n.submit icon="n-icon-arrow_switch" onclick="return doImp();" group="start">import</@n.submit>
			<@n.submit icon="n-icon-arrow_switch" onclick="return doDel();">truncate</@n.submit>
			<@n.submit icon="n-icon-arrow_switch" onclick="return doInx();" group="end">index</@n.submit>
		</@n.form>

		<div class="hr"></div>

		<div>
			<@n.submit icon="n-icon-stop" onclick="doStop()">stop</@n.submit>
			<@n.submit icon="n-icon-bullet_go" onclick="doPeek()">peek</@n.submit>
		</div>
		
		<br/>
		<div id="goodsindex_t"></div>
		
		<br/>
		<div id="goodsindex_i">
		</div>
		<br/>
		<br/>

		<script type="text/javascript">
			var $hr;
			var pms = [];

			function doStop() {
				var data = {
					__decorator: 'none'
				};

				$.ajaf({
					url: "<@n.url action='goodsindex_stop'/>",
					data: data,
					success: function(data) {
						$('#goodsindex_t').html('<pre>' + data.formatXml().escapeHtml() + '</pre>');
					},
					error: function(xhr, status, e) {
						$('#goodsindex_t').html('<div class="error">' + String.escapeHtml(xhr.responseText) + '</div>');
					}
				});
			}
			
			var peek;
			function doPeek() {
				if (peek) {
					clearInterval(peek);
					peek = null;
					$('#goodsindex_t').empty();
				}
				else {
					peek = setInterval(function() {
						var data = {
							__decorator: 'none'
						};
		
						$.ajaf({
							url: "<@n.url action='goodsindex_peek'/>",
							data: data,
							success: function(data) {
								$('#goodsindex_t').html('<pre>' + data.formatXml().escapeHtml() + '</pre>');
							},
							error: function(xhr, status, e) {
								$('#goodsindex_t').html('<div class="error">' + String.escapeHtml(xhr.responseText) + '</div>');
							}
						});
					}, 1000);
				}
			}
			
			function doInx() {
				doWork("<@n.url action='goodsindex_index'/>");
				return false;
			}
			
			function doImp() {
				doWork("<@n.url action='goodsindex_impex'/>");
				return false;
			}
			
			function doDel() {
				doWork("<@n.url action='goodsindex_trunc'/>");
				return false;
			}
			
			function doWork(url) {
				$('#goodsindex').loadmask();
				$('#goodsindex_t').empty();
				
				$hr = $('<div class="hr"></div>').appendTo($('#goodsindex_i').empty());
				pms = [];

				var data = {
					__decorator: 'none',
					start: $('#goodsindex_start').val(),
					limit: $('#goodsindex_limit').val(),
					words: $('#goodsindex_words').val(),
					error: 'parent.s1_imp_error("{0}");',
					process: 'parent.s1_imp_process({0}, "{1}");',
					success: 'parent.s1_imp_success("{0}");'
				};
				
				$.ajaf({
					url: url,
					data: data,
					success: function(d) {
						$('#goodsindex').unloadmask();
					},
					error: function(xhr, status, e) {
						$('#goodsindex').unloadmask();
						$hr.after('<div class="error">' + String.escapeHtml(xhr.responseText) + '</div>');
					}
				});
			}
			
			function s1_imp_error(msg) {
				$hr.after('<pre class="error">' + String.escapeHtml(msg).replace(/\r\n/g, '<br/>') + '</pre>');
			}
			
			function s1_imp_success(msg) {
				msg = '{0} items processed.'.replace('{0}', msg);
				$hr.after('<div>' + String.escapeHtml(msg).replace(/\r\n/g, '<br/>') + '</div>');
			}
			
			function s1_imp_process(progress, msg) {
				var $m = $('<div>' + String.escapeHtml(progress + '. ' + msg).replace(/\r\n/g, '<br/>') + '</div>');

				$hr.after($m);
				pms.push($m);

				while (pms.length > 20) {
					pms.shift().remove();
				}
			}
		</script>
	</div>
</div>

</body>
</html>
