<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
	<style type="text/css">
		table.report {
			width: 100%;
		}
		table.report th, table.report td {
			padding: 2px 5px;
			text-align: right;
		}
	</style>
</head>
<body>

<div class="n-sect" id="a_report_list">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><@n.text name="title-page"/></h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>

		<@n.form action="report_list" id="reportany" method="get" cssClass="condform" theme="nxhtml">
			<@n.datepicker key="dr.f" size="12" maxlength="10" required="true"/>
			<@n.datepicker key="dr.t" size="12" maxlength="10" required="true"/>
			<@n.submit icon="n-icon-report"><@n.text name="button-report"/></@n.submit>
		</@n.form>
		
	<#if dataList??>
		<div class="report" style="margin-top: 5px">
			<table class="n-table report">
			<thead>
				<th><@n.text name="header-date"/></th>
				<th><@n.text name="header-supplyAmount"/></th>
				<th><@n.text name="header-soldAmount"/></th>
			</thead>
			<#assign sumSupplyAmount = 0/>
			<#assign sumSoldAmount = 0/>
			<#assign monthSupplyAmount = 0/>
			<#assign monthSoldAmount = 0/>
			<#assign yearSupplyAmount = 0/>
			<#assign yearSoldAmount = 0/>
			<tbody>
			<#list dataList as d>
				<#if d_index gt 0>
					<#if saveDate.month != d.date.month>
						<tr class="sumg">
					    	<th nowrap><@n.text name="label-sumMonth"><@s.param>${saveDate?string('M')}</@s.param></@n.text></th>
					    	<td nowrap>${monthSupplyAmount}</td>
					    	<td nowrap>${monthSoldAmount}</td>
					    </tr>
						<tr class="sumg">
					    	<th nowrap><@n.text name="label-calcMonth"><@s.param>${saveDate?string('M')}</@s.param></@n.text></th>
					    	<td nowrap colspan="2"><span class="<#if monthSoldAmount lt monthSupplyAmount>minus<#else>plus</#if>">
					    		${monthSoldAmount - monthSupplyAmount}</span></td>
					    </tr>
					</#if>
					<#assign monthSupplyAmount = 0/>
					<#assign monthSoldAmount = 0/>
		
					<#if saveDate.year != d.date.year>
						<tr class="sumg">
					    	<th nowrap><@n.text name="label-sumYear"><@s.param>${saveDate?string('yyyy')}</@s.param></@n.text></th>
					    	<td nowrap>${yearSupplyAmount}</td>
					    	<td nowrap>${yearSoldAmount}</td>
					    </tr>
						<tr class="sumg">
					    	<th nowrap><@n.text name="label-calcYear"><@s.param>${saveDate?string('yyyy')}</@s.param></@n.text></th>
					    	<td nowrap colspan="2"><span class="<#if yearSoldAmount lt yearSupplyAmount>minus<#else>plus</#if>">
					    		${yearSoldAmount - yearSupplyAmount}</span></td>
					    </tr>
					</#if>
					<#assign yearSupplyAmount = 0/>
					<#assign yearSoldAmount = 0/>
				</#if>
				<#if d.supplyAmount??>
					<#assign sumSupplyAmount = sumSupplyAmount + d.supplyAmount/>
					<#assign monthSupplyAmount = monthSupplyAmount + d.supplyAmount/>
					<#assign yearSupplyAmount = yearSupplyAmount + d.supplyAmount/>
				</#if>
				<#if d.soldAmount??>
					<#assign sumSoldAmount = sumSoldAmount + d.soldAmount/>
					<#assign monthSoldAmount = monthSoldAmount + d.soldAmount/>
					<#assign yearSoldAmount = yearSoldAmount + d.soldAmount/>
				</#if>
				<tr class="${(d_index % 2 == 0)?string('odd', 'even')}">
			    	<th width="100" nowrap><@n.date value=d.date format="date"/></th>
			    	<td nowrap>${d.supplyAmount!}</td>
			    	<td nowrap>${d.soldAmount!}</td>
			    </tr>
				<#if !d_has_next>
				<tr class="sumg">
			    	<th nowrap><@n.text name="label-sumMonth"><@s.param>${d.date?string('M')}</@s.param></@n.text></th>
			    	<td nowrap>${monthSupplyAmount}</td>
			    	<td nowrap>${monthSoldAmount}</td>
			    </tr>
				<tr class="sumg">
			    	<th nowrap><@n.text name="label-calcMonth"><@s.param>${d.date?string('M')}</@s.param></@n.text></th>
			    	<td nowrap colspan="2"><span class="<#if monthSoldAmount lt monthSupplyAmount>minus<#else>plus</#if>">
				    		${monthSoldAmount - monthSupplyAmount}</span></td>
			    </tr>
				<tr class="sumg">
			    	<th nowrap><@n.text name="label-sumYear"><@s.param>${d.date?string('yyyy')}</@s.param></@n.text></th>
			    	<td nowrap>${yearSupplyAmount}</td>
			    	<td nowrap>${yearSoldAmount}</td>
			    </tr>
				<tr class="sumg">
			    	<th nowrap><@n.text name="label-calcYear"><@s.param>${d.date?string('yyyy')}</@s.param></@n.text></th>
			    	<td nowrap colspan="2"><span class="<#if yearSoldAmount lt yearSupplyAmount>minus<#else>plus</#if>">
			    		${yearSoldAmount - yearSupplyAmount}</span></td>
			    </tr>
				<tr class="sum">
			    	<th nowrap><@n.text name="label-sumTotal"/></th>
			    	<td nowrap>${sumSupplyAmount}</td>
			    	<td nowrap>${sumSoldAmount}</td>
			    </tr>
				<tr class="sum">
			    	<th nowrap><@n.text name="label-calcTotal"/></th>
			    	<td nowrap colspan="2"><span class="<#if sumSoldAmount lt sumSupplyAmount>minus<#else>plus</#if>">
			    		${sumSoldAmount - sumSupplyAmount}</span></td>
			    </tr>
				</#if>
				<#assign saveDate=d.date/>
			</#list>
			</tbody>
			</table>
		</div>
	</#if>
	</div>
</div>

</body>
</html>

