<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title></title>
</head>

<body>

<div class="n-sect" id="a_cart_list">
	<div class="n-sect-head">
		<em class="n-sect-icon n-icon n-icon-basket"></em>
		<h3 class="n-sect-title"><@n.text name="menu-cart"/></h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>
		
		<#if !cart.empty>
		<div class="s-cart-list">
			<div class="s-cart-btnt n-nowrap">
				<@n.submit icon="n-icon-basket_edit" onclick="return cart_edit_go();"><@n.text name="link-change"/></@n.submit>
				<@n.submit icon="n-icon-basket_go" onclick="return cart_order_go();"><@n.text name="link-order"/></@n.submit>
			</div>
		
			<div class="s-cart-goods">
			<ol>
			<#assign _sp_ = 0 />
			<#list cart.items as ci>
				<#assign _sp_ = _sp_ + ci.goods.salePrice * ci.quantity />
				<@n.url var="_vurl_" action="goods_view">
					<@s.param name="gid">${ci.goodsId}</@s.param>
				</@n.url>
				<li>
					<a class="goods-link" href="${_vurl_}">${ci.goods.name?html}</a><br/>
					<@n.text name="label-quantity"/>${ci.quantity}<br/>
					<@n.text name="label-sale-price"/><span <#rt/>
class="sale-price"><@n.text name="format-price"><@s.param value="${ci.goods.salePrice?c}"/></@n.text></span>
				</li>
			</#list>
			</ol>
		
			<div class="shr"></div>
			<b>&nbsp;<@n.text name="label-sum-price"/></b>
			<span class="sale-price"><@n.text name="format-price"><@s.param value="${_sp_?c}"/></@n.text></span>
			</div>
		
			<div class="s-cart-btnf n-nowrap">
				<@n.submit icon="n-icon-basket_edit" onclick="return cart_edit_go();"><@n.text name="link-change"/></@n.submit>
				<@n.submit icon="n-icon-basket_go" onclick="return cart_order_go();"><@n.text name="link-order"/></@n.submit>
			</div>
		</div>
		
		<script type="text/javascript">
			function cart_edit_go() {
				location.href = "<@n.url action='cart_edit'/>";
				return false;
			}
			function cart_order_go() {
				location.href = "<@n.url action='order_input' namespace='/user'/>";
				return false;
			}
		</script>
		</#if>
	</div>
</div>
</body>
</html>
