<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title>
		<#if qq.k?has_content>
			<@n.text name="title-search"><@s.param value="qq.k"/></@n.text><#rt/>
		<#elseif category??>
			${category.name?html}
		<#else>
			<@n.text name="title-page"/><#rt/>
		</#if>
	</title>
</head>

<body>

<div class="n-sect" id="a_goods_list">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><#rt/>
		<#if qq.k?has_content>
			<@n.text name="title-search"><@s.param><span class="site-search-text">"${qq.k}"</span></@s.param></@n.text><#rt/>
		<#else>
			<#include "location.ftl"/>
		</#if>
		</h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>

		<@n.form id="goods" method="get" theme="simple">
			<@n.hidden name="cid"/>
			<@n.hidden name="qq.k"/>
			<@n.hidden name="qq.t"/>
			<@n.hidden name="pg.s"/>
			<@n.hidden name="pg.l"/>
			<@n.hidden name="so.c"/>
			<@n.hidden name="so.d"/>
		</@n.form>

	<#if goodsList?has_content>
		<@n.url var="url">
			<@s.param name="cid" value="cid"/>
			<@s.param name="qq.k" value="qq.k"/>
			<@s.param name="qq.t" value="qq.t"/>
			<@s.param name="pg.l" value="pg.l"/>
			<@s.param name="so.c" value="so.c"/>
			<@s.param name="so.d" value="so.d"/>
		</@n.url>
		<#assign linkHref = url + "&amp;pg.s=?"/>

		<#include "goods_list-pager.ftl"/>
		<div class="hrt"></div>

		<#list goodsList as g>
		<span class="goods-thumb">
			<@n.url var="_vurl_" action="goods_view">
				<@s.param name="gid">${g.id}</@s.param>
			</@n.url>
			<@n.url var="_iurl_" action="gi" namespace="/images">
				<@s.param name="gid">${g.id}</@s.param>
			</@n.url>

			<a class="goods-icon" href="${_vurl_}"><img src="${_iurl_}"/></a><br/>
			<span class="goods-name">
				<a href="${_vurl_}">${g.name?html}
					<span class="list_price">(<@n.text name="format-price"><@s.param value="${g.salePrice?c}"/></@n.text>)</span>
				</a><br/>
				<#if g.stockQuantity gt 0>
				<@n.a icon="n-icon-basket_add" href="#" onclick="return addToCart(this, '${g.id}');"><@n.text name="link-addToCart"/></@n.a>
				<#else>
					<@n.text name="label-soldout"/>
				</#if>
			</span>
		</span>
		</#list>

		<div class="hrb"></div>
		<#include "goods_list-pager.ftl"/>

		<script type="text/javascript">
			function addToCart(el, gid) {
				s_cart_add(
					el,
					'<@n.url action="cart_add" namespace="/"/>', 
					gid
				);
				return false;
			}
		</script>
	</#if>
	</div>

	<#if category?? && category.childs?has_content>
	<div class="hr"></div>
	<div class="n-sect-head">
		<h3 class="n-sect-title"><@n.text name="title-subcategory"/></h3>
	</div>
	<div class="n-sect-body">
		<#list category.childs! as c>
		<span class="category-thumb">
			<@n.url var="_lurl_" action="goods_list"><@s.param name="cid">${c.id}</@s.param></@n.url>
			<@n.url var="_iurl_" action="ci" namespace="/images">
				<@s.param name="cid">${c.id}</@s.param>
			</@n.url>
			<a class="category-icon" href="${_lurl_}"><img src="${_iurl_}"/></a><br/>
			<a class="category-name" href="${_lurl_}">${c.name?html}</a>
			<#if c.childs?has_content>
			<ul>
				<#list c.childs as c2>
				<li><a class="category-name" href="<@n.url action="goods_list"><@s.param name="cid">${c2.id}</@s.param></@n.url>">${c2.name?html}</a></li>
				</#list>
			</ul>
			</#if>
		</span>
		</#list>
	</div>
	</#if>
</div>

</body>
</html>
