<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><#if goods??>${goods.name?html}</#if></title>
</head>

<body>

<div class="n-sect" id="a_goods_view">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><#include "location.ftl"/></h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>

	<#if goods??>
		<table class="goodsview"><tbody>
		<tr>
			<td class="goodsview-galy">
				<div class="goodsview-iw"> 
				    <img src="${static}/nuts/images/s.gif"/> 
				</div>
			<#if goodsThumbs?has_content>
				<div id="goods_gallery">
				<#list goodsThumbs as i>
					<@n.url var="_url" action='gi' namespace='/images'>
						<@s.param name="gid">${goods.id}</@s.param>
						<@s.param name="gin">${i}</@s.param>
					</@n.url>
					<a href="${_url}" title="${i?html}"><img src="${_url}"/></a>
				</#list>
				</div>
	<script type="text/javascript">
		$(function() {
			$('#goods_gallery a')
				.lightBox()
				.mouseenter(function() { 
					$("#goods_gallery img.selected").removeClass("selected");
					var $i = $(this).children('img');
					$i.addClass("selected");
					$(".goodsview-iw img").attr("src", $i.attr("src"));
				}).eq(0).triggerHandler("mouseenter");

			$(".goodsview-iw img")
				.css("cursor", "pointer")
				.click(function() {
					$("#goods_gallery img.selected")
						.parent().triggerHandler('click');
				});
		});
	</script>
			</#if>
			</td>
			<td class="goodsview-intr">
				<span class="goods-name">${goods.name?html}</span>
				<div class="hr"></div>
				<table>
			<#if goods.listPrice??>
					<tr><td class="label"><@n.text name="label-list-price"/></td>
						<td><span class="list-price"><@n.text name="format-price"><@s.param value="${goods.listPrice?c}"/></@n.text></span></td>
					</tr>
			</#if>
					<tr><td class="label"><@n.text name="label-sale-price"/></td>
						<td><span class="sale-price"><@n.text name="format-price"><@s.param value="${goods.salePrice?c}"/></@n.text></span></td>
					</tr>
			<#if goods.discount??>
					<tr><td class="label"><@n.text name="label-discount"/></td>
						<td><span class="discount"><@n.text name="format-price"><@s.param value="${(goods.listPrice - goods.salePrice)?c}"/></@n.text>
							(${goods.discount?c}%)</span></td>
					</tr>
			</#if>
				</table>

				<#if goods.stockQuantity gt 0>
				<table><tr>
					<td><@n.text name="label-quantity"/></td>
					<td><@n.select list="%{{1, 2, 3, 4, 5, 6, 7, 8, 9}}" theme="simple"/></td>
					<td><@n.a icon="n-icon-basket_add" href="#" onclick="return addToCart(this, '${goods.id}');"><@n.text name="link-addToCart"/></@n.a></td>
				</tr></table>
				<#else>
				<@n.text name="label-soldout"/>
				</#if>

				<ul>
				<#if goods.title?has_content>
					<li><span class="label"><@n.text name="goods.title"/>:</span>
						<span class="value">${goods.title?html}</span>
					</li>
				</#if>
				<#if goods.author?has_content>
					<li><span class="label"><@n.text name="goods.author"/>:</span>
						<span class="value">${goods.author?html}</span>
					</li>
				</#if>
				<#if goods.artist?has_content>
					<li><span class="label"><@n.text name="goods.artist"/>:</span>
						<span class="value">${goods.artist?html}</span>
					</li>
				</#if>
				<#if goods.album?has_content>
					<li><span class="label"><@n.text name="goods.album"/>:</span>
						<span class="value">${goods.album?html}</span>
					</li>
				</#if>
				<#if goods.director?has_content>
					<li><span class="label"><@n.text name="goods.director"/>:</span>
						<span class="value">${goods.director?html}</span>
					</li>
				</#if>
				<#if goods.language?has_content>
					<li><span class="label"><@n.text name="goods.language"/>:</span>
						<span class="value">${consts.goodsLanguageMap[goods.language]}</span>
					</li>
				</#if>
				<#if goods.subtitle?has_content>
					<li><span class="label"><@n.text name="goods.subtitle"/>:</span>
						<span class="value">${consts.goodsSubtitleMap[goods.subtitle]}</span>
					</li>
				</#if>
				<#if goods.format?has_content>
					<li><span class="label"><@n.text name="goods.format"/>:</span>
						<span class="value">${consts.goodsFormatMap[goods.format]}</span>
					</li>
				</#if>
				<#if goods.targetAge?has_content>
					<li><span class="label"><@n.text name="goods.targetAge"/>:</span>
						<span class="value">${goods.targetAge?html}</span>
					</li>
				</#if>
				<#if goods.makerName?has_content>
					<li><span class="label"><@n.text name="goods.makerName"/>:</span>
						<span class="value">${goods.makerName?html}</span>
					</li>
				</#if>
				<#if goods.platformName?has_content>
					<li><span class="label"><@n.text name="goods.platformName"/>:</span>
						<span class="value">${goods.platformName?html}</span>
					</li>
				</#if>
				<#if goods.publishDate?has_content>
					<li><span class="label"><@n.text name="goods.publishDate"/>:</span>
						<span class="value"><@n.property name="goods.publishDate" format="date"/></span>
					</li>
				</#if>
				</ul>			
			</td>
		</tr>
		<tr><td colspan="2" class="goodsview-content">${goods.content?if_exists}</td></tr>
		</tbody></table>
		<script type="text/javascript">
			function addToCart(el, gid) {
				var q = $(el).closest('tr').find('select').val();
				s_cart_add(
					el,
					'<@n.url action="cart_add" namespace="/"/>', 
					gid, 
					q
				);
				return false;
			}
		</script>

		<br/><div class="hr"></div>
		<h4 class="xhead"><@n.text name="label-goods-review"/></h4>
		<div id="goodsview_review_panel" class="xbody">
			<div id="goodsview_review_list_panel"></div>
			<div class="hr"></div>
			<div id="goodsview_review_input_panel"></div>
		</div>

		<br/>
		<br/><div class="hr"></div>
		<h4 class="xhead"><@n.text name="label-goods-comment"/></h4>
		<div id="goodsview_comment_panel" class="xbody">
			<div id="goodsview_comment_list_panel"></div>
			<div class="hr"></div>
			<div id="goodsview_comment_input_panel"></div>
		</div>

		<br/><br/>

		<script type="text/javascript">
			function goodsReviewListLoad() {
				$("#goodsview_review_list_panel").load("<@n.url action='goodsreview_list' escapeAmp='false'><@s.param name="gid">${goods.id}</@s.param><@s.param name='__inner' value='true'/></@n.url>");
			}
			
			function goodsReviewInputLoad() {
				$("#goodsview_review_input_panel").load("<@n.url action='goodsreview_input' escapeAmp='false'><@s.param name="gid">${goods.id}</@s.param><@s.param name='__inner' value='true'/></@n.url>");
			}

			function goodsCommentListLoad() {
				$("#goodsview_comment_list_panel").load("<@n.url action='goodscomment_list' escapeAmp='false'><@s.param name="gid">${goods.id}</@s.param><@s.param name='__inner' value='true'/></@n.url>");
			}
			
			function goodsCommentInputLoad() {
				$("#goodsview_comment_input_panel").load("<@n.url action='goodscomment_input' escapeAmp='false'><@s.param name="gid">${goods.id}</@s.param><@s.param name='__inner' value='true'/></@n.url>");
			}

			var goodsReviewLoaded = false;
			var goodsCommentLoaded = false;
			function goodsAdditionView() {
				if (!goodsReviewLoaded) {
					var $w = $(window);
					if ($w.scrollTop() + $w.height() > $("#goodsview_review_panel").offset().top) {
						goodsReviewListLoad();
						goodsReviewInputLoad();
						goodsReviewLoaded = true;
					}
				}
				if (!goodsCommentLoaded) {
					var $w = $(window);
					if ($w.scrollTop() + $w.height() > $("#goodsview_comment_panel").offset().top) {
						goodsCommentListLoad();
						goodsCommentInputLoad();
						goodsCommentLoaded = true;
					}
				}
			}
			
			$(function() {
				goodsAdditionView();
				$(window).scroll(goodsAdditionView);
			});
		</script>
	</#if>
	</div>
</div>

</body>
</html>
