<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
</head>

<body>

<div id="a_index">
<#macro gthumb g>
			<span class="goods-thumb">
				<@n.url var="_vurl_" action="goods_view">
					<@s.param name="gid">${g.id}</@s.param>
				</@n.url>
				<@n.url var="_iurl_" action="gi" namespace="/images">
					<@s.param name="gid">${g.id}</@s.param>
				</@n.url>
				<div class="goods-icon"><a href="${_vurl_}"><img src="${_iurl_}"></a></div>
				<div class="goods-name"><a href="${_vurl_}">${g.name?html}</a></div>
			</span>
</#macro>

	<div class="n-sect">
		<div class="n-sect-head">
			<h3 class="n-sect-title"><@n.text name="title-goodsBestSales"/></h3>
		</div>
		<div class="n-sect-body">
		<#if Application.goodsBestSales??>
			<#list Application.goodsBestSales as g>
				<#if g_index gt 3>
					<#break>
				</#if>
				<@gthumb g=g/>
			</#list>
		</#if>
		</div>
	
		<br/><div class="hr"></div>
	
		<div class="n-sect-head">
			<h3 class="n-sect-title"><@n.text name="title-category"/></h3>
		</div>
		<div class="n-sect-body">
			<#assign _ctl_ = Application.categoryTopList![] />
			<#list _ctl_ as c>
			<span class="category-thumb">
				<@n.url var="_lurl_" action="goods_list">
					<@s.param name="cid">${c.id}</@s.param>
				</@n.url>
				<@n.url var="_iurl_" action="ci" namespace="/images">
					<@s.param name="cid">${c.id}</@s.param>
				</@n.url>
				<a class="category-icon" href="${_lurl_}"><img src="${_iurl_}"/></a><br/>
				<a class="category-name" href="${_lurl_}">${c.name?html}</a>
				<#if c.childs?has_content>
				<ul>
					<#list c.childs as c2>
					<li><a class="category-name" href="<@n.url action="goods_list"><@s.param name="cid">${c2.id}</@s.param></@n.url>">${c2.name?html}</a></li>
					</#list>
				</ul>
				</#if>
			</span>
			</#list>
		</div>
	</div>
</div>

</body>
</html>

