<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title"><@s.param><@n.text name="title-${step}"/></@s.param></@n.text></title>
</head>

<body>

<div class="n-sect" id="a_order_confirm">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><@n.text name="title"><@s.param><@n.text name="title-${step}"/></@s.param></@n.text></h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt-all.ftl"/>
		<br/>
	
		<@n.form id="order" action="order_execute" method="post" loadmask="false" theme="simple">
		<@n.hidden name="step"/>

		<table width="100%"><tr>
			<td><h2 class="caption"><@n.text name="label-before-order"> </@n.text></h2></td>
			<td align="right"><@n.submit icon="n-icon-tick"><@n.text name="button-order"/></@n.submit></td>
		</tr></table>
		<br/>

		<#if !cart.empty>
		<#assign _sum_price = 0 />
		<table class="cart-table">
		<thead class="xhead">
			<tr>
				<th colspan="3"><@n.text name="label-cart-list"/></th>
				<th class="sale-price"><@n.text name="label-sale-price"/></th>
				<th class="goods-quantity"><@n.text name="label-quantity"/></th>
			</tr>
		</thead>
		<tbody>
		<#list cart.items as ci><#if gids?? && gids?seq_contains(ci.goodsId)>
			<#assign _sum_price = _sum_price + ci.goods.salePrice * ci.quantity />
			<@n.url var="_url_" action="goods_view" namespace="/">
				<@s.param name="gid">${ci.goodsId}</@s.param>
			</@n.url>
			<tr><td colspan="5"><div class="hr"/></td></tr>
			<tr>
				<td class="item-no">${ci_index + 1}.<input type="hidden" name="gids" value="${ci.goodsId}"/></td>
				<td class="goods-icon"><a href="${_url_}"><img src="<@n.url action="gi" namespace="/images">
						<@s.param name="gid">${ci.goodsId}</@s.param></@n.url>"/></a>
				</td>
				<td class="goods-name"><a href="${_url_}">${ci.goods.name?html}</a></td>
				<td class="sale-price"><@n.text name="format-price"><@s.param value="${ci.goods.salePrice?c}"/></@n.text></td>
				<td class="goods-quantity">${ci.quantity}</td>
			</tr>
		</#if></#list>
		</tbody>
		<tfoot>
			<tr><td colspan="5"><div class="hr"/></td></tr>
			<tr>
				<td colspan="4" align="right">
					<span class="sum-price">
						<@n.text name="label-sum-price"/>&nbsp;
						<@n.text name="format-price"><@s.param value="${_sum_price?c}"/></@n.text>
					</span>
				</td>
				<td></td>
			</tr>
		</tfoot>
		</table>
		<br/>
		</#if>
	
		<h4 class="xhead"><@n.text name="label-confirm-address"/></h4>
		<div class="xbody">
			<table>
				<@n.hidden name="caId"/>
				<@n.viewfield key="ca.name" theme="nxhtml"/>
				<@n.viewfield key="ca.zipcode" theme="nxhtml"/>
				<@n.viewfield key="ca.address" theme="nxhtml"/>
				<@n.viewfield key="ca.company" theme="nxhtml"/>
				<@n.viewfield key="ca.phone" theme="nxhtml"/>
			</table>
		</div>
	
		<h4 class="xhead"><@n.text name="label-confirm-delivery"/></h4>
		<div class="xbody">
			<table>
				<@n.viewfield key="co.deliveryKind" list="consts.deliveryKindMap" theme="nxhtml"/>
				<@n.viewfield key="co.deliveryDate" format="date" theme="nxhtml"/>
				<@n.viewfield key="co.deliveryTime" list="consts.deliveryTimeMap" theme="nxhtml"/>
				<@n.viewfield key="co.memo" theme="nxhtml"/>
			</table>
		</div>
	
		<h4 class="xhead"><@n.text name="label-confirm-payment"/></h4>
		<div class="xbody">
			<table>
				<@n.viewfield key="co.paymentKind" list="consts.paymentKindMap" theme="nxhtml"/>
			<#if co.paymentKind == 'C'> 
				<@n.viewfield key="ccc.cardType" list="consts.creditCardTypeMap" theme="nxhtml"/>
				<@n.viewfield key="ccc.cardNo" expression="ccc.cardNo.substring(0, ccc.cardNo.length()-4)+'XXXX'" theme="nxhtml"/>	
				<@n.viewfield key="ccc.cardName" theme="nxhtml"/>
				<@n.viewfield key="ccc.cardExpires" theme="nxhtml"/>
				<@n.hidden name="cccId"/>
			</#if>
			</table>
		</div>

		<div class="shr"></div>
		<table width="100%"><tr>
			<td><h2 class="caption"><@n.text name="label-before-order"> </@n.text></h2></td>
			<td align="right"><@n.submit icon="n-icon-tick" theme="simple"><@n.text name="button-order"/></@n.submit></td>
		</tr></table>
	</@n.form>
	</div>
</div>

</body>
</html>
