<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-${actionResult}"><@s.param><@n.text name="title"/></@s.param></@n.text></title>
</head>
<body>

<div class="n-sect">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><@n.text name="title-${actionResult}"><@s.param><@n.text name="title"/></@s.param></@n.text></h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>

		<@n.form cssClass="n-eform" id="goodsreview" method="post" theme="nxhtml">
			<@n.hidden
				name="d.id"
			/>
			<@n.hidden
				name="userOrderItemId"
			/>
			<@n.hidden
				name="d.goodsId"
			/>
			<@n.hidden
				name="d.goodsCode"
			/>
			<@n.hidden
				name="d.goodsName"
			/>
			<@n.radio
				name="d.rank"
				required="true"
				list="consts.reviewRankMap"
				label="%{getText('insert-rank', '')}"
				tooltip="%{getText('insert-rank-tip', '')}"
			>
			</@n.radio>
			<@n.textfield
				name="d.title"
				required="true"
				maxlength="40"
				size="42"
				label="%{getText('insert-title', '')}"
				tooltip="%{getText('insert-title-tip', '')}"
			>
			</@n.textfield>
			<@n.textarea
				name="d.review"
				required="true"
				maxlength="1000"
				cols="80"
				rows="12"
				label="%{getText('insert-review', '')}"
				tooltip="%{getText('insert-review-tip', '')}"
			>
			</@n.textarea>
			<@n.hidden
				name="d.date"
			/>
			<@n.hidden
				name="d.voteOk"
			/>
			<@n.hidden
				name="d.voteNo"
			/>

			<@n.submit icon="n-icon-comment_add" action="goodsreview_insertConfirm"><@n.text name="button-insert-confirm"/></@n.submit>
		</@n.form>
	</div>
</div>

</body>
</html>
