Ext.ns('squirrels', 'squirrels.ecshop', 'squirrels.ecshop.admin');

Ext.apply(Nexts.module.SliduModule.prototype.defaultFormCtConfig, {
	width: 430
});

Ext.apply(Nexts.module.SliduModule.prototype.defaultFormConfig, {
	labelWidth: 115,
	width: 400,
	clayout: 'column',
	clayoutConfig: {
		columns: 1
	},
	defaults: {
		width: 255,
		msgTarget: 'under'
	}
});

squirrels.ecshop.admin.SliduModule = Ext.extend(Nexts.module.SliduModule, {
	iconCls: 'ne-icon-module',

	shortcutIconCls: 'ne-icon-module32',

	copyFilters: [ 'id', 'invalid', 'ctime', 'cruid', 'crunm', 'utime', 'upuid', 'upunm' ],
	
	getStaticFieldsConfig: function() {
		return {
	   		'invalid':	{ type: 'boolean', 	list: { hidden: true }, filter: true, deleteFlag: true, editor: { inputValue: '1' } },
			'ctime':	{ type: 'date', 	list: true, 	filter: true, 	dateFormat: this.getText('dateFormat.datetime'), editor: { xtype: 'textfield', readOnly: true } }, 
			'cruid':	{ type: 'int', 		list: false, 	filter: true,	editor: false },
			'crunm':	{ type: 'string', 	list: true, 	filter: true,	editor: { readOnly: true } },
			'utime':	{ type: 'date', 	list: true, 	filter: true, 	dateFormat: this.getText('dateFormat.datetime'), editor: { xtype: 'textfield', readOnly: true } }, 
			'upuid':	{ type: 'int', 		list: false, 	filter: true,	editor: false },
			'upunm':	{ type: 'string', 	list: true, 	filter: true,	editor: { readOnly: true } }
		};
	}, 

	initConfig: function() {
		if (this.urlPattern) {
			this.listConfig = this.listConfig || {};
			if (!this.listConfig.url) {
				this.listConfig.url = this.urlPattern.replace(/\*/g, 'list');
			}
			this.formConfig = this.formConfig || {};
			if (!this.formConfig.selectUrl) {
				this.formConfig.selectUrl = this.urlPattern.replace(/\*/g, 'selectExecute');
			}
			if (!this.formConfig.insertUrl) {
				this.formConfig.insertUrl = this.urlPattern.replace(/\*/g, 'insertExecute');
			}
			if (!this.formConfig.updateUrl) {
				this.formConfig.updateUrl = this.urlPattern.replace(/\*/g, 'updateExecute');
			}
			if (!this.formConfig.deleteUrl) {
				this.formConfig.deleteUrl = this.urlPattern.replace(/\*/g, 'deleteExecute');
			}
		}

		this.fieldsConfig = Ext.apply(this.fieldsConfig, this.getStaticFieldsConfig());

		squirrels.ecshop.admin.SliduModule.superclass.initConfig.call(this);
	}
});


squirrels.ecshop.admin.Application = function() {
	smApp = this;

	squirrels.ecshop.admin.Application.superclass.constructor.apply(this, arguments);
};

Ext.extend(squirrels.ecshop.admin.Application, Nexts.Applet, {

	wallpapers: [
		[ 'Blue Curtain', 		'images/wallpapers/blue-curtain.jpg',		'images/wallpapers/thumbnails/blue-curtain.jpg' 	],
		[ 'Blue Psychedelic', 	'images/wallpapers/blue-psychedelic.jpg',	'images/wallpapers/thumbnails/blue-psychedelic.jpg' ],
		[ 'Curls On Green', 	'images/wallpapers/curls-on-green.jpg',		'images/wallpapers/thumbnails/curls-on-green.jpg' 	],
		[ 'Eos', 				'images/wallpapers/eos.jpg',				'images/wallpapers/thumbnails/eos.jpg' 				]
	],
	
	hasPermit: function(name, access) {
/*		access = "can" + access.capitalize();

		var rts = this.user.rollItems;
		for (var i = 0; i < rts.length; i++) {
			var rt = rts[i];
			if (rt.name == name) {
				return rt[access] == '1';
			}
		}
*/
		return true;
	},

	initApp: function() {
		this.httpProvider = new Nexts.state.HttpProvider({
			readUrl: 'usersp_load.ac',
			saveUrl: 'usersp_save.ac',
			autoLoad: false,
			listeners: {
				loadsuccess: this.onStateLoadSuccess,
				loadfailure: this.onStateLoadFailure,
				scope: this
			}
		});

		Ext.state.Manager.setProvider(this.httpProvider);

		new Nexts.module.LoginModule({
			cookieId: 'ssa-ticket',
			url: 'login_login.ac'
		});
		
		squirrels.ecshop.admin.Application.superclass.initApp.call(this);
	},

	onLogin: function(result) {
		this.user = result.user;

		if (!this.desktop) {
			if (this.httpProvider) {
				this.stateMask = new Ext.LoadMask(Ext.getBody());
				this.stateMask.show();
				this.httpProvider.loadState();
			}
			else {
				this.initDesktop();
			}
		}
	},

	onStateLoadSuccess: function() {
		this.stateMask.hide();
		this.stateMask.destroy();
		delete this.stateMask;
		this.initDesktop();
	},

	onStateLoadFailure: function() {
		this.onStateLoadSuccess();
	},

	// config for the start menu
	getStartConfig: function() {
		return {
			title: this.user.name
		};
	},

	// config for the desktop
	getDesktopConfig: function() {
		// The next line is being replaced with the config by os.php
		var dc = {
			launchers: {
				contextmenu: [
					"module.preferences"
				],
				startmenutool: [
					"module.preferences",
					"module.logout"
				],
				startmenu: [
					"menu.account",
					"menu.customer",
					"menu.sale",
					"menu.system"
				],
				autorun: [
//					"module.preferences"
				],
				quickstart: [
					"module.preferences",
					"squirrels.ecshop.admin.PasswordModule",
					"squirrels.ecshop.admin.CategoryModule",
					"squirrels.ecshop.admin.GoodsModule",
					"squirrels.ecshop.admin.SupplementModule",
					"squirrels.ecshop.admin.CustomerModule",
					"squirrels.ecshop.admin.CustomerorderModule"
				],
				shortcut: [
					"module.preferences",
					"squirrels.ecshop.admin.CategoryimageModule",
					"squirrels.ecshop.admin.CategoryModule",
					"squirrels.ecshop.admin.CustomeraddressModule",
					"squirrels.ecshop.admin.CustomercreditcardModule",
					"squirrels.ecshop.admin.CustomerModule",
					"squirrels.ecshop.admin.CustomerorderitemModule",
					"squirrels.ecshop.admin.CustomerorderModule",
					"squirrels.ecshop.admin.CustomerwantedModule",
					"squirrels.ecshop.admin.GoodscommentModule",
					"squirrels.ecshop.admin.GoodsimageModule",
					"squirrels.ecshop.admin.GoodsModule",
					"squirrels.ecshop.admin.GoodsreviewModule",
					"squirrels.ecshop.admin.MakerModule",
					"squirrels.ecshop.admin.PlatformModule",
					"squirrels.ecshop.admin.SupplementModule",
					"squirrels.ecshop.admin.SupplierModule"
				]
			},
			styles: {
				backgroundcolor: "FFFFFF",
				fontcolor: "000000",
				transparency: true,
				theme: {
					css: "xtheme-default.css"
				},
				wallpaper: {
					image: "../../../static/nexts/images/wallpapers/nexts.gif",
					position: "center"
				}
			}
		};

		var sdc = Ext.state.Manager.get("desktop.config");
		if (!Ext.isEmpty(sdc)) {
			try {
				dc = Ext.decode(sdc);
			}
			catch (e) {
				console.warn(e);
			}
		}

		return dc;
	},

	// modules to initialize (make available to your desktop)
	initModules: function() {
		new Nexts.module.MenuModule({
			id: 'menu.account',
			title: this.getText('menu.account'),
			items: [
				"squirrels.ecshop.admin.PasswordModule",
				"squirrels.ecshop.admin.UserModule",
				"squirrels.ecshop.admin.UsergroupModule",
				"squirrels.ecshop.admin.UserpermitModule"
			]
		});
		new Nexts.module.MenuModule({
			id: 'menu.customer',
			title: this.getText('menu.customer'),
			items: [
				"squirrels.ecshop.admin.CustomerModule",
				"squirrels.ecshop.admin.CustomeraddressModule",
				"squirrels.ecshop.admin.CustomercreditcardModule",
				"squirrels.ecshop.admin.CustomerwantedModule"
			]
		});
		new Nexts.module.MenuModule({
			id: 'menu.stock',
			title: this.getText('menu.stock'),
			items: [
				"squirrels.ecshop.admin.CategoryModule",
				"squirrels.ecshop.admin.CategoryimageModule",
				"squirrels.ecshop.admin.MakerModule",
				"squirrels.ecshop.admin.PlatformModule",
				"squirrels.ecshop.admin.GoodsModule",
				"squirrels.ecshop.admin.GoodsimageModule",
				"squirrels.ecshop.admin.GoodscommentModule",
				"squirrels.ecshop.admin.GoodsreviewModule",
			]
		});
		new Nexts.module.MenuModule({
			id: 'menu.sale',
			title: this.getText('menu.sale'),
			items: [
				"squirrels.ecshop.admin.SupplierModule",
				"squirrels.ecshop.admin.SupplementModule",
				"squirrels.ecshop.admin.CustomerorderModule",
				"squirrels.ecshop.admin.CustomerorderitemModule"
			]
		});
		new Nexts.module.MenuModule({
			id: 'menu.system',
			title: this.getText('menu.system'),
			items: [
				"squirrels.ecshop.admin.ActionpermitModule",
				"squirrels.ecshop.admin.ResourceModule",
				"squirrels.ecshop.admin.TemplateModule",
				"squirrels.ecshop.admin.UserstateModule"
			]
		});

		new Nexts.module.PreferencesModule({
			id: 'module.preferences',
			configId: 'desktop.config',
			wallpapers: this.wallpapers
		});

		var m = new Nexts.module.LogoutModule({
			id: 'module.logout',
			url: 'login_logout.ac',
			cookieId: 'ssa-ticket'
		});
		
		if (this.hasPermit('password', 'view')) {
			new squirrels.ecshop.admin.PasswordModule({
				listeners: {
					passwordchanged: this.onPasswordChanged,
					scope: this
				}
			});
		}

		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.ActionpermitModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.CategoryimageModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.CategoryModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.CustomeraddressModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.CustomercreditcardModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.CustomerModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.CustomerorderitemModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.CustomerorderModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.CustomerwantedModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.GoodscommentModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.GoodsimageModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.GoodsModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.GoodsreviewModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.MakerModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.PlatformModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.ResourceModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.SupplementModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.SupplierModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.TemplateModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.UsergroupModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.UserModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.UserpermitModule();
		}
		if (this.hasPermit('category', 'view')) {
			new squirrels.ecshop.admin.UserstateModule();
		}
	},

	onPasswordChanged: function(np) {
		this.user.password = np;
	}
});

