squirrels.ecshop.admin.PasswordModule = Ext.extend(Nexts.module.FormModule, {

	id: 'squirrels.ecshop.admin.PasswordModule',
	
	iconCls: 'ne-icon-form',

	shortcutIconCls: 'ne-icon-form32',

	windowConfig: {
		width: 410,
		height: 250
	},
	
	initConfig: function() {
		this.formConfig = {
			url: 'userpwd_change.ac',
			labelWidth: 160,
			bodyStyle: 'padding: 5px 5px 15px 5px',
			defaults: { 
				width: 200,
				inputType: 'password',
				allowBlank: false,
				minLength: 6,
				maxLength: 16,
				msgTarget: 'under'
			},
			items: [{
				xtype: 'textfield',
				name: 'oldPassword',
				fieldLabel: this.getText('fieldLabel.oldPassword')
			},{
				xtype: 'textfield',
				name: 'newPassword',
				fieldLabel: this.getText('fieldLabel.newPassword')
			},{
				xtype: 'textfield',
				name: 'confirmPassword',
				fieldLabel: this.getText('fieldLabel.confirmPassword')
			}],
			buttons: [{
				text: this.getText('button.change'),
				handler: function() {
					this.form.getForm().subload({waitMsg: this.getText('label.waitMsg')});
				},
				scope: this
			}, {
				text: this.getText('button.reset'),
				handler: function() {
					this.form.getForm().reset();
				},
				scope: this
			}, {
				text: this.getText('button.close'),
				handler: function() {
					this.closeModule();
				},
				scope: this
			}],
			listeners: {
				actioncomplete: function(form, action) {
					this.form.formMessages.addInfo(this.getText("message.success"));
					this.fireEvent("passwordchanged", formPanel.getForm().findField('newPassword').getValue());
				},
				scope: this
			}
		};
		
		squirrels.ecshop.admin.PasswordModule.superclass.initConfig.call(this);

		this.addEvents('passwordchanged');
	}
});



