/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

/**
 * Application
 */
public class Application extends MyApplet {

	private static FileObject categoryImagesDir;
	
	private static FileObject goodsImagesDir;

	/**
	 * @return the luceneDirectory
	 */
	public static Directory getLuceneDirectory() {
		return luceneDirectory;
	}

	/**
	 * @return the luceneIndexWriter
	 */
	public static IndexWriter getLuceneIndexWriter() throws Exception {
		return MyApplet.getLuceneIndexWriter();
	}

	/**
	 * @return the categoryImagesDir
	 */
	public static FileObject getCategoryImagesDir() {
		return categoryImagesDir;
	}

	/**
	 * @return the goodsImagesDir
	 */
	public static FileObject getGoodsImagesDir() {
		return goodsImagesDir;
	}

	/**
	 * initialize
	 */
	@Override
	protected void initialize() throws Exception {
		super.initialize();

		initDatabaseResourcesLoader();
		
		initDatabaseTemplateLoader();

		buildLuceneDirectory();
		
		loadDirectores();

		initActionPermits();
	}

	private void loadDirectores() throws Exception {
		categoryImagesDir = VFS.getManager().resolveFile(getPropertyAsPath("category.images"));
		goodsImagesDir = VFS.getManager().resolveFile(getPropertyAsPath("goods.images"));
	}
}
