/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.admin;

import java.util.Calendar;
import java.util.List;

import nuts.aems.model.bean.User;

import squirrels.ecshop.model.bean.UserState;
import squirrels.ecshop.model.dao.UserStateDAO;
import squirrels.ecshop.model.example.UserStateExample;

/**
 */
@SuppressWarnings("serial")
public class UserStateProviderAction extends AbstractAdminAction {

	private List<UserState> data;

	/**
	 * @return data
	 */
	public List<UserState> getData() {
		return data;
	}

	/**
	 * @param data the data to set
	 */
	public void setData(List<UserState> data) {
		this.data = data;
	}

	/**
	 * load
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String load() throws Exception {
		UserStateDAO dao = new UserStateDAO(getDataAccessSession());

		UserStateExample example = new UserStateExample();

		example.userId().equalTo(utils().getLoginUser().getId());

		data = dao.selectByExample(example);

		return SUCCESS;
	}

	/**
	 * clear
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String clear() throws Exception {
		UserStateDAO dao = new UserStateDAO(getDataAccessSession());

		UserStateExample example = new UserStateExample();

		example.userId().equalTo(utils().getLoginUser().getId());

		dao.deleteByExample(example);

		return SUCCESS;
	}

	/**
	 * save
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String save() throws Exception {
		if (data != null) {
			List<UserState> usl = data;
			
			data = null;
			
			User user = utils().getLoginUser();

			UserStateDAO dao = new UserStateDAO(getDataAccessSession());
			UserStateExample example = new UserStateExample();
			example.userId().equalTo(user.getId());
			
			dao.deleteByExample(example);
			
			for (UserState us : usl) {
				us.setUserId(user.getId());
				us.setInvalid(false);
				us.setCusid(user.getId());
				us.setCtime(Calendar.getInstance().getTime());
				us.setUusid(user.getId());
				us.setUtime(Calendar.getInstance().getTime());
				dao.insert(us);
			}

			getDataAccessSession().commit();
		}

		return SUCCESS;
	}

}
